% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addPlot.R
\name{addPlot}
\alias{addPlot}
\alias{addPlot.bsdoc}
\alias{addPlot.docx}
\alias{addPlot.pptx}
\title{Add a plot into a document object}
\usage{
addPlot(doc, fun, pointsize = 12, vector.graphic = F, ...)

\method{addPlot}{docx}(doc, fun, pointsize = getOption("ReporteRs-fontsize"),
  vector.graphic = FALSE, width = 6, height = 6,
  fontname = getOption("ReporteRs-default-font"),
  fontname_serif = "Times New Roman", fontname_sans = "Calibri",
  fontname_mono = "Courier New", fontname_symbol = "Symbol",
  editable = TRUE, bookmark, par.properties = parProperties(text.align =
  "center", padding = 5), bg = "white", ...)

\method{addPlot}{pptx}(doc, fun, pointsize = 11, vector.graphic = TRUE,
  fontname = getOption("ReporteRs-default-font"),
  fontname_serif = "Times New Roman", fontname_sans = "Calibri",
  fontname_mono = "Courier New", fontname_symbol = "Symbol",
  editable = TRUE, offx, offy, width, height, bg = "white", ...)

\method{addPlot}{bsdoc}(doc, fun, pointsize = getOption("ReporteRs-fontsize"),
  vector.graphic = T, width = 6, height = 6,
  fontname = getOption("ReporteRs-default-font"),
  fontname_serif = "Times New Roman", fontname_sans = "Calibri",
  fontname_mono = "Courier New", fontname_symbol = "Symbol",
  par.properties = parCenter(padding = 5), bg = "white", ...)
}
\arguments{
\item{doc}{document object}

\item{fun}{plot function. The function will be executed to produce graphics.
For \code{grid} or \code{lattice} or \code{ggplot} object, the function
should just be \code{print} and an extra argument \code{x} should specify the object
to plot. For traditionnal plots, the function should contain plot instructions. See examples.}

\item{pointsize}{the default pointsize of plotted text in pixels, default to 12 pixels.}

\item{vector.graphic}{logical scalar, if TRUE, vector graphics are
produced instead, PNG images if FALSE.}

\item{...}{further arguments passed to or from other methods. See details.}

\item{width}{plot width in inches (default value is 6).}

\item{height}{plot height in inches (default value is 6).}

\item{fontname}{deprecated. the default font family to use, default to getOption("ReporteRs-default-font").}

\item{fontname_serif, fontname_sans, fontname_mono, fontname_symbol}{font
names for font faces. Use fonts available on operating system.}

\item{editable}{logical value - if TRUE vector graphics elements (points, text, etc.) are editable.}

\item{bookmark}{id of the Word bookmark to replace by the plot. optional.

\code{bookmark} is a character vector specifying bookmark id to replace by the plot(s).\cr
      If provided, plot(s) will replace the paragraph that contains the bookmark. See \code{\link{bookmark}}.\cr
      If not provided, plot(s) will be added at the end of the document.}

\item{par.properties}{paragraph formatting properties of the paragraph that contains plot(s).
An object of class \code{\link{parProperties}}}

\item{bg}{the initial background colour.}

\item{offx, offy}{optional. x and y position of the shape (left top position of the bounding box) in inches. See details.}
}
\value{
a document object
}
\description{
Add a plot into a document object
}
\details{
Plot parameters are specified with the \code{...} argument.
However, the most convenient usage is to wrap the plot code
into a function whose parameters will be specified as '...'.

If you want to add ggplot2 or lattice plot, use \code{print} function.

\code{vector.graphic}: SVG will be produced for \code{bsdoc} objects
and DrawingML instructions for \code{docx} and \code{pptx} objects.
Don't use vector graphics if document is a docx and MS Word version
used to open the document is 2007.

When document is a \code{pptx} object, two positioning methods are available.

If arguments offx, offy, width, height are missing, position and dimensions
will be defined by the width and height of the next available shape of the slide. This
dimensions can be defined in the layout of the PowerPoint template used to create
the \code{pptx} object.

If arguments offx, offy, width, height are provided, they become position and
dimensions of the new shape.
}
\examples{

# plot example for docx -----
doc.filename = "ex_plot.docx"
options( "ReporteRs-fontsize" = 11 )
doc = docx( )
doc = addPlot( doc, fun = function() barplot( 1:6, col = 2:7),
  vector.graphic = TRUE, width = 5, height = 7,
  par.properties = parProperties(text.align = "left")
  )
writeDoc( doc, file = doc.filename )

# plot example for pptx -----
doc.filename = "ex_plot.pptx"
options( "ReporteRs-fontsize" = 11 )
doc = pptx( )
doc = addSlide( doc, slide.layout = "Title and Content" )
doc = addPlot( doc, fun = function() barplot( 1:6, col = 2:7),
  vector.graphic = TRUE, width = 5, height = 7 )
doc = addPlot( doc, fun = function() barplot( 1:6, col = 2:7),
  vector.graphic = FALSE,
  offx = 7, offy = 0,
  width = 3, height = 2
  )
writeDoc( doc, file = doc.filename )

# plot example for bsdoc -----
doc.filename = "ex_plot/example.html"
options( "ReporteRs-fontsize" = 11 )
doc = bsdoc( )
doc = addPlot( doc, fun = function() barplot( 1:6, col = 2:7),
  vector.graphic = TRUE, width = 5, height = 7,
  par.properties = parProperties(text.align = "left")
  )
writeDoc( doc, file = doc.filename )
}
\seealso{
\code{\link{docx}}, \code{\link{docx}}, \code{\link{bsdoc}}
}

