/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.html4r.elements.menu;

import java.util.LinkedList;
import org.lysis.reporters.html4r.elements.menu.MenuLink;
import org.lysis.reporters.html4r.elements.menu.Separator;
import org.lysis.reporters.tools.HTML4R;

public class Dropdown
implements HTML4R {
    private LinkedList<HTML4R> items = new LinkedList();
    private String label;
    private boolean active;

    public Dropdown(String lab) {
        this.label = lab;
        this.active = false;
    }

    public void setActive() {
        this.active = true;
    }

    public void addSeparator() {
        this.items.add(new Separator());
    }

    public void add(String label, String link, boolean active) {
        MenuLink l = new MenuLink(label, link);
        if (active) {
            l.setActive();
        }
        this.items.add(l);
    }

    public void add(Dropdown d) {
        this.items.add(d);
    }

    @Override
    public String getHTML() {
        String out = "<li class=\"dropdown";
        if (this.active) {
            out = String.valueOf(out) + " active";
        }
        out = String.valueOf(out) + "\"><a href=\"#\" class=\"dropdown-toggle\" data-toggle=\"dropdown\">";
        out = String.valueOf(out) + this.label;
        out = String.valueOf(out) + "<b class=\"caret\"></b></a>";
        if (this.items.size() > 0) {
            out = String.valueOf(out) + "<ul class=\"dropdown-menu\">";
            int i = 0;
            while (i < this.items.size()) {
                out = String.valueOf(out) + this.items.get(i).getHTML();
                ++i;
            }
            out = String.valueOf(out) + "</ul>";
        }
        out = String.valueOf(out) + "</li>";
        return out;
    }

    @Override
    public String getCSS() {
        return "";
    }

    @Override
    public String getJS() {
        return "";
    }

    @Override
    public boolean hasJS() {
        return false;
    }

    @Override
    public boolean hasCSS() {
        return false;
    }

    @Override
    public boolean hasHTML() {
        return true;
    }
}

