/*
 * This file is part of ReporteRs
 * Copyright (c) 2014, David Gohel All rights reserved.
 * This program is licensed under the GNU GENERAL PUBLIC LICENSE V3.
 * You may obtain a copy of the License at :
 * http://www.gnu.org/licenses/gpl.html
 */

package org.lysis.reporters.text;

import org.lysis.reporters.formats.ParProperties;
import org.lysis.reporters.tools.DOCX4R;
import org.lysis.reporters.tools.HTML4R;
import org.lysis.reporters.tools.PPTX4R;

public class CodeBlock extends ParagraphSet implements HTML4R, PPTX4R, DOCX4R{
	
	public CodeBlock( ParProperties parProp ){
		super(parProp);
	}


	@Override
	public String getHTML() {
		String out = "<pre><code>";

		if( size() > 0 ){
			for(int i = 0 ; i < size() ; i++ ){
				Paragraph p = get(i);
				p.setHTMLReference(list_id, counters, numbDefinition);
				p.setVanilla();
				out += p.getHTML() + "\n";
			}
		}
		
		out += "</code></pre>";
		
		return out;
	}

	@Override
	public String getCSS() {
		return "";
	}

	@Override
	public String getJS() {
		return "";
	}

	@Override
	public boolean hasJS() {
		return false;
	}

	@Override
	public boolean hasHTML() {
		return true;
	}

	@Override
	public boolean hasCSS() {
		return false;
	}


}
