% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculation.R
\name{gene2ko}
\alias{gene2ko}
\title{Transfer gene symbol table to KO table}
\usage{
gene2ko(genedf, org = "hsa")
}
\arguments{
\item{genedf}{,rowname is gene symbol (e.g. PFKM), colnames is samples}

\item{org}{kegg organism, listed in 'https://www.genome.jp/kegg/catalog/org_list.html', default, 'hsa'}
}
\value{
kodf
}
\description{
You can use `clusterProfiler::bitr()` to transfer your table from other gene_id to gene_symbol.
}
\examples{
data("genedf")
KOdf <- gene2ko(genedf, org = "hsa")
}
