% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculation.R
\name{up_level_KO}
\alias{up_level_KO}
\title{Upgrade the KO level}
\usage{
up_level_KO(
  KO_abundance,
  level = "pathway",
  show_name = FALSE,
  modulelist = NULL,
  verbose = TRUE
)
}
\arguments{
\item{KO_abundance}{KO_abundance}

\item{level}{one of 'pathway', 'module', 'level1', 'level2', 'level3', 'module1', 'module2', 'module3'.}

\item{show_name}{logical}

\item{modulelist}{NULL or customized modulelist dataframe, must contain 'id','K_num','KOs','Description' columns. Take the `KOlist` as example, use \code{\link{custom_modulelist}}.}

\item{verbose}{logical}
}
\value{
data.frame
}
\description{
Upgrade the KO level
}
\examples{
data("KO_abundance_test")
KO_level1 <- up_level_KO(KO_abundance, level = "level1", show_name = TRUE)
}
