% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Seriesplot.fn.R
\name{Seriesplot.fn}
\alias{Seriesplot.fn}
\title{Function to plot series data}
\usage{
Seriesplot.fn(
  x,
  y,
  xRange = NA,
  yRange = NA,
  points = TRUE,
  pch = 1,
  col.point = 1,
  cex.point = 1,
  line = TRUE,
  lty = 1,
  col.line = 1,
  lwd = 1,
  xlab = "x",
  ylab = "y",
  main = ""
)
}
\arguments{
\item{x}{a vector for the x-axis coordinate of a sequence.}

\item{y}{a vector for the y-axis coordinates of a sequence.}

\item{xRange}{range for the x-axis.}

\item{yRange}{range for the y-axis.}

\item{points}{whether to draw the points of the sequence. If points = TRUE, a sequence of points will be plotted. otherwise, will not plot the points.}

\item{pch}{points types.}

\item{col.point}{color code or name of the points.}

\item{cex.point}{cex of points}

\item{line}{whether to draw a line of the sequence. If line = TRUE, a line of sequence will be plotted. otherwise, will not plot the line.}

\item{lty}{line types.}

\item{col.line}{color code or name of the line.}

\item{lwd}{line width.}

\item{xlab}{a title for the x axis.}

\item{ylab}{a title for the y axis.}

\item{main}{main title for the picture.}
}
\value{
No value return
}
\description{
function to plot series data. including Respiration data and
Peak-to-Peak intervals series.
}
\examples{
data("TestData")
oldpar <- par(mfrow=c(1,2))
Seriesplot.fn(Data[1:10000,1],Data[1:10000,2],points=FALSE,xlab="Time(s)",ylab="Respiration")
Fs=50 ## sampling frequency is 50Hz
Peaks <- find.peaks(Data[,2],Fs,lowpass=TRUE,freq=1,MovingAv=FALSE,
                    W=FALSE,filter=TRUE,threshold=0.05)
PP_interval=diff(Peaks[,1])/Fs
Seriesplot.fn(1:length(PP_interval),PP_interval,points=FALSE,xlab="Count",ylab="Interval(s)")
par(oldpar)

}
