% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuthBackendBasic.R
\docType{data}
\name{AuthBackendBasic}
\alias{AuthBackendBasic}
\title{Basic authorization backend}
\format{\link[R6:R6Class]{R6::R6Class} object.}
\description{
Creates AuthBackendBasic class object.
}
\section{Construction}{
\preformatted{AuthBackendBasic$new(FUN)
}
\itemize{
\item \code{FUN} :: \code{function}\cr
\code{character(1)}, \code{character(1)} -> \code{logical(1)} \cr
Function to perform authentication which takes two arguments - \code{user} and \code{password}.
Returns boolean - whether access is allowed for a requested \code{user} or not.
}
}

\section{Methods}{

\itemize{
\item \code{authenticate(request, response)}\cr
\link{Request}, \link{Response} -> \code{NULL}\cr
Provide authentication for the given request.
}
}

\examples{
# init users database
user_db = list(
  "user-1" = "password-1",
  "user-2" = "password-2"
)
# define authentication handler
auth_fun = function(user, password) {
  if (is.null(user_db[[user]])) return(FALSE) # not found
  if (!identical(user_db[[user]], password)) return(FALSE) # incorrect
  return(TRUE)
}
# init backend
auth_backend = AuthBackendBasic$new(FUN = auth_fun)

# test backend
# define credentials (see RFC)
creds = jsonlite::base64_enc("user-1:password-1")
# generate request headers
h = list("Authorization" = sprintf("Basic \%s", creds))
# simulate request
rq = Request$new(path = "/", headers = h)
# init response object
rs = Response$new()
# perform authentication
auth_backend$authenticate(rq, rs) # TRUE

}
\references{
\href{https://tools.ietf.org/html/rfc7617}{RFC7617}
\href{https://en.wikipedia.org/wiki/Basic_access_authentication}{Wikipedia}
}
\seealso{
\link{AuthMiddleware} \link{Request} \link{Response}

Other AuthBackend: \code{\link{AuthBackendBearer}},
  \code{\link{AuthBackend}}, \code{\link{AuthMiddleware}}
}
\concept{AuthBackend}
\keyword{datasets}
