% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFriends.R
\name{getFriends}
\alias{getFriends}
\title{Extract list of friends with their information}
\usage{
getFriends(token, simplify = FALSE)
}
\arguments{
\item{token}{Either a temporary access token created at
\url{https://developers.facebook.com/tools/explorer} or the OAuth token 
created with \code{fbOAuth}.}

\item{simplify}{If \code{TRUE}, function will return only name and id for each friend.
If \code{FALSE}, it will return additional information from their profiles: gender, birthday,
location, hometown, relationship status and profile picture.}
}
\description{
\code{getFriends} retrieves information about the user's friends.
}
\details{
This function requires the use of a OAuth token with extended 
permissions. After the introduction of version 2.0 of the Graph API,
only friends who are using the application that you used to generate the 
token to query the API will be returned.
}
\examples{
\dontrun{
## Copy and paste token created at FB Graph API Explorer
 token <- "XXXXXX"
my_friends <- getFriends(token=token, simplify=TRUE)
## Since users are ordered by ID, this will return 10 oldest user accounts
head(my_friends, n=10)
}

}
\author{
Pablo Barbera \email{pablo.barbera@nyu.edu}
}
\seealso{
\code{\link{getUsers}}, \code{\link{fbOAuth}}
}

