% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{search_reference_bases}
\alias{search_reference_bases}
\title{Search for Reference Bases}
\usage{
search_reference_bases(client, reference_id = NULL, start = NULL,
  end = NULL, page_size = NULL, page_token = NULL)
}
\arguments{
\item{client}{A ga4gh_client object}

\item{reference_id}{The ID of the Reference to search within}

\item{start}{The start position (0-based) of this query. Defaults to 0. Genomic positions
are non-negative integers less than reference length. Requests spanning the join of circular
genomes are represented as two requests one on each side of the join (position 0).}

\item{end}{The end position (0-based, exclusive) of this query. Defaults to the length of this Reference}

\item{page_size}{Specifies the maximum number of results to return in a single page.
If unspecified, the client default will be used.}

\item{page_token}{The continuation token, which is used to page through
large result sets. To get the next page of results, set this parameter to
the value of nextPageToken from the previous response.}
}
\description{
Search for Reference Bases
}
\examples{

ref_client <- ga4gh_client("http://1kgenomes.ga4gh.org", api_location = "")

\dontrun{
library(magrittr)
## Find a reference set to search in
reference_sets <- ref_client \%>\% search_reference_sets() \%>\% content()
rs_id <- reference_sets$referenceSets[[1]]$id

## Find a reference to search in
references <- ref_client \%>\% search_references(rs_id) \%>\% content()
ref_id <- references$references[[1]]$id

## Find a string of bases from 10000 -> 11000
reference_bases <- ref_client \%>\%
 search_reference_bases(ref_id, start = 10000, end = 11000) \%>\% content()
reference_bases
}
}

