% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{search_rna_quantifications}
\alias{search_rna_quantifications}
\title{Search for RNA Quantifications}
\usage{
search_rna_quantifications(client, rna_quantification_set_id,
  page_size = NULL, page_token = NULL)
}
\arguments{
\item{client}{A ga4gh_client object}

\item{rna_quantification_set_id}{The ID of the RNA Quantification Set to search within}

\item{page_size}{Specifies the maximum number of results to return in a single page.
If unspecified, the client default will be used.}

\item{page_token}{The continuation token, which is used to page through
large result sets. To get the next page of results, set this parameter to
the value of nextPageToken from the previous response.}
}
\description{
Search for RNA Quantifications
}
\examples{

ref_client <- ga4gh_client("http://1kgenomes.ga4gh.org", api_location = "")

\dontrun{

library(magrittr)
## Find a dataset to search in
datasets <- ref_client \%>\% search_datasets() \%>\% content()
d_id <- datasets$datasets[[1]]$id

## Find an rna quantification set to search in
rna_quantification_sets <- ref_client \%>\%
 search_rna_quantification_sets(d_id) \%>\% content()
rqs_id <- rna_quantification_sets$rnaQuantificationSets[[1]]$id

## Search for rna quantifications in the rna quantification set
rna_quantifications <- ref_client \%>\%
 search_rna_quantifications(rqs_id) \%>\% content()
rna_quantifications
}

}

