% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{search_variants}
\alias{search_variants}
\title{Search for Variants}
\usage{
search_variants(client, variant_set_id, call_set_ids = NULL,
  reference_name = NULL, start = NULL, end = NULL, page_size = NULL,
  page_token = NULL)
}
\arguments{
\item{client}{A ga4gh_client object}

\item{variant_set_id}{The ID of the Variant Set to search within}

\item{call_set_ids}{A list of Call Set IDs. Only return variant calls which belong to call sets
with these IDs. If unspecified, return all variants and no variant call objects.}

\item{reference_name}{Only return variants on this reference.}

\item{start}{The beginning of the window (0-based, inclusive) for which overlapping variants should be returned.
Genomic positions are non-negative integers less than reference length.}

\item{end}{The end of the window (0-based, exclusive) for which overlapping variants should be returned.}

\item{page_size}{Specifies the maximum number of results to return in a single page.
If unspecified, the client default will be used.}

\item{page_token}{The continuation token, which is used to page through
large result sets. To get the next page of results, set this parameter to
the value of nextPageToken from the previous response.}
}
\description{
Search for Variants
}
\examples{

ref_client <- ga4gh_client("http://1kgenomes.ga4gh.org", api_location = "")

\dontrun{
library(magrittr)
## Find a dataset to search in
datasets <- ref_client \%>\% search_datasets() \%>\% content()
d_id <- datasets$datasets[[1]]$id

## Find a variant set to search in
variant_sets <- ref_client \%>\% search_variant_sets(d_id) \%>\% content()
vs_id <- variant_sets$variantSets[[1]]$id

## Search for variants in the variant set
variants <- ref_client \%>\% search_variants(vs_id, reference_name = "1") \%>\%
 content()
variants$variants[[1]]
}

}

