% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof_power_disc.R
\name{gof_power_disc}
\alias{gof_power_disc}
\title{Find the power of various gof tests for discrete data.}
\usage{
gof_power_disc(
  pnull,
  rnull,
  vals,
  ralt,
  param_alt,
  phat = function(x) -99,
  TS,
  TSextra = NA,
  alpha = 0.05,
  B = 1000,
  nbins = c(100, 10),
  rate = 0,
  maxProcessor,
  minexpcount = 5,
  ChiUsePhat = TRUE
)
}
\arguments{
\item{pnull}{cumulative distribution function under the null hypothesis}

\item{rnull}{a function to generate data under  null hypothesis}

\item{vals}{values of discrete rv.}

\item{ralt}{function to generate data under  alternative hypothesis}

\item{param_alt}{vector of parameter values for distribution under alternative hypothesis}

\item{phat}{=function(x) -99, function to estimate parameters from the data, -99 if no parameters are estimated}

\item{TS}{user supplied function to find test statistics, if any}

\item{TSextra}{=NA, list passed to TS, if desired}

\item{alpha}{=0.05, the level of the hypothesis test}

\item{B}{=1000 number of simulation runs}

\item{nbins}{=c(100, 10) number of bins for chi square tests}

\item{rate}{rate of Poisson if sample size is random}

\item{maxProcessor}{maximum of number of processors to use, 1 if no parallel processing is needed or number of cores-1 if missing}

\item{minexpcount}{=5 minimal number of expected counts in each bin for chi square tests}

\item{ChiUsePhat}{= TRUE, if TRUE param is estimated parameter, otherwise minimum chi square method is used.}
}
\value{
A numeric matrix of power values.
}
\description{
Find the power of various gof tests for discrete data.
}
