% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrap08spdk.R
\name{wrap.spdk}
\alias{wrap.spdk}
\title{Prepare Data on SPD Manifold of Fixed-Rank}
\usage{
wrap.spdk(input, k)
}
\arguments{
\item{input}{data matrices to be wrapped as \code{riemdata} class. Following inputs are considered,
\describe{
\item{array}{a \eqn{(p\times p\times n)} array where each slice along 3rd dimension is a rank-\eqn{k} matrix.}
\item{list}{a length-\eqn{n} list whose elements are \eqn{(p\times p)} matrices of rank-\eqn{k}.}
}}

\item{k}{rank of the SPD matrices.}
}
\value{
a named \code{riemdata} S3 object containing
\describe{
  \item{data}{a list of \eqn{(p\times k)} representation of the corresponding rank-\eqn{k} SPSD matrices.}
  \item{size}{size of each representation matrix.}
  \item{name}{name of the manifold of interests, \emph{"spdk"}}
}
}
\description{
When \eqn{(p\times p)} SPD matrices are of fixed-rank \eqn{k < p}, they form 
a geometric structure represented by \eqn{(p\times k)} matrices,
\deqn{SPD(k,p) = \lbrace X \in \mathbf{R}^{(p\times p)}~\vert~ Y Y^\top = X, \textrm{rank}(X) = k \rbrace}
It's key difference from \eqn{\mathcal{S}_{++}^p} is that all matrices should be 
of fixed rank \eqn{k} where \eqn{k} is usually smaller than \eqn{p}. Inputs are 
given as \eqn{(p\times p)} matrices with specified \eqn{k} and \code{wrap.spdk} 
automatically decomposes input square matrices into rank-\eqn{k} representation matrices.
}
\examples{
#-------------------------------------------------------------------
#                 Checker for Two Types of Inputs
#-------------------------------------------------------------------
#  Data Generation
d1 = array(0,c(10,10,3))
d2 = list()
for (i in 1:3){
  dat = matrix(rnorm(10*10),ncol=10)
  d1[,,i] = stats::cov(dat)
  d2[[i]] = d1[,,i]
}

#  Run
test1 = wrap.spdk(d1, k=2)
test2 = wrap.spdk(d2, k=2)


}
\references{
\insertRef{journee_lowrank_2010}{Riemann}
}
\concept{wrapper}
