% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IEX_Market_Data.R
\name{iex.chart}
\alias{iex.chart}
\title{Returns adjusted and unadjusted historical data for up to 15 years. Useful for building charts.}
\usage{
iex.chart(x, r, iex_sk)
}
\arguments{
\item{x}{A charcter vector that can include one or multiple  Tickers / Stocks Symbols}

\item{r}{An alpha numeric object that represents the time range selected.}

\item{iex_sk}{is a character vector that include IEX Cloud API Secret Token}
}
\value{
Data frame that includes stock (s) financial data
}
\description{
For more details, visit:\url{https://iexcloud.io/docs/api/#historical-prices}
}
\note{
r takes only of of the values accepted IN API request. {"5y", "2y", "1y", "ytd", "6m", "3m", "1m", "1d"}
}
\examples{
\donttest{
  iex.chart("TSLA", "1y")
}
}
\seealso{
Investors Exchange `IEX` developer guide \url{https://iexcloud.io/docs/api/}

Investors Exchange Group (IEX Group) offers flexible and salable pricing.\url{https://iexcloud.io/pricing/}

View Investors Exchange Group (IEX Group) terms of use and subscription levels.\url{https://iexcloud.io/terms/}

Package `iexcloudR`\url{https://github.com/schardtbc/iexcloudR}
}
\author{
Myriam Ibrahim
}
