% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_3pl.R
\name{estimate_3pl}
\alias{estimate_3pl}
\alias{model_3pl_eap}
\alias{model_3pl_map}
\alias{model_3pl_dv_Pt}
\alias{model_3pl_dv_Pa}
\alias{model_3pl_dv_Pb}
\alias{model_3pl_dv_Pc}
\alias{model_3pl_dv_jmle}
\alias{model_3pl_jmle}
\alias{model_3pl_dv_mmle}
\alias{model_3pl_mmle}
\alias{model_3pl_fitplot}
\title{Estimation of the 3PL model}
\usage{
model_3pl_eap(u, a, b, c, D = 1.702, priors = c(0, 1),
  bounds_t = c(-4, 4))

model_3pl_map(u, a, b, c, D = 1.702, priors = c(0, 1),
  bounds_t = c(-4, 4), iter = 30, conv = 0.001)

model_3pl_dv_Pt(t, a, b, c, D)

model_3pl_dv_Pa(t, a, b, c, D)

model_3pl_dv_Pb(t, a, b, c, D)

model_3pl_dv_Pc(t, a, b, c, D)

model_3pl_dv_jmle(pdv_fn, u, t, a, b, c, D)

model_3pl_jmle(u, t = NA, a = NA, b = NA, c = NA, D = 1.702,
  iter = 100, conv = 0.001, nr_iter = 10, scale = c(0, 1),
  bounds_t = c(-4, 4), bounds_a = c(0.01, 2.5), bounds_b = c(-4, 4),
  bounds_c = c(0, 0.4), priors = list(t = c(0, 1)), decay = 1,
  verbose = FALSE, true_params = NULL)

model_3pl_dv_mmle(pdv_fn, u, quad, a, b, c, D)

model_3pl_mmle(u, t = NA, a = NA, b = NA, c = NA, D = 1.702,
  iter = 100, conv = 0.001, nr_iter = 10, bounds_t = c(-4, 4),
  bounds_a = c(0.01, 2.5), bounds_b = c(-4, 4), bounds_c = c(0, 0.4),
  priors = list(t = c(0, 1)), decay = 1, quad = "11",
  score_fn = c("eap", "map"), verbose = FALSE, true_params = NULL)

model_3pl_fitplot(u, t, a, b, c, D = 1.702, index = NULL,
  intervals = seq(-3, 3, 0.5))
}
\arguments{
\item{u}{observed response matrix, 2d matrix}

\item{a}{discrimination parameters, 1d vector (fixed value) or NA (freely estimate)}

\item{b}{difficulty parameters, 1d vector (fixed value) or NA (freely estimate)}

\item{c}{pseudo-guessing parameters, 1d vector (fixed value) or NA (freely estimate)}

\item{D}{the scaling constant, 1.702 by default}

\item{priors}{prior distributions, a list}

\item{bounds_t}{the bounds of ability parameters}

\item{iter}{the maximum iterations, default=100}

\item{conv}{the convergence criterion}

\item{t}{ability parameters, 1d vector (fixed value) or NA (freely estimate)}

\item{pdv_fn}{the function to compute derivatives of P w.r.t the estimating parameters}

\item{nr_iter}{the maximum newton-raphson iterations, default=10}

\item{scale}{the mean and SD of the theta scale, default=\code{c(0,1)} in JMLE}

\item{bounds_a}{the bounds of discrimination parameters}

\item{bounds_b}{the bounds of difficulty parameters}

\item{bounds_c}{the bounds of guessing parameters}

\item{decay}{decay rate, default=1}

\item{verbose}{TRUE to print details for debugging}

\item{true_params}{a list of true parameters for evaluating the parameter recovery}

\item{quad}{the number of quadrature points}

\item{score_fn}{the scoring function: 'eap' or 'map'}

\item{index}{the indices of items being plotted}

\item{intervals}{intervals on the x-axis}
}
\value{
\code{model_3pl_eap} returns theta estimates and standard errors in a list

\code{model_3pl_map} returns theta estimates in a list

\code{model_3pl_jmle} returns estimated t, a, b, c parameters in a list

\code{model_3pl_mmle} returns estimated t, a, b, c parameters in a list

\code{model_3pl_fitplot} returns a \code{ggplot} object
}
\description{
Estimate the 3PL model using the joint or marginal 
maximum likelihood estimation methods

\code{model_3pl_eap} scores response vectors using the EAP method

\code{model_3pl_map} scores response vectors using the MAP method

\code{model_3pl_jmle} estimates the item and ability parameters
using the joint maximum likelihood estimation (JMLE) method

\code{model_3pl_mmle} estimates the item parameters using the 
marginal maximum likelihood estimation (MMLE) method
}
\examples{
with(model_3pl_gendata(10, 40), 
    cbind(true=t, est=model_3pl_eap(u, a, b, c)$t))
with(model_3pl_gendata(10, 40), 
     cbind(true=t, est=model_3pl_map(u, a, b, c)$t))
\donttest{
# generate data
x <- model_3pl_gendata(2000, 40)
# free estimation, 40 iterations
y <- model_3pl_jmle(x$u, true_params=x, iter=40, verbose=TRUE)
# fix c-parameters, 40 iterations
y <- model_3pl_jmle(x$u, c=0, true_params=x, iter=40)
}
\donttest{
# generate data
x <- model_3pl_gendata(2000, 40)
# free estimation, 40 iterations
y <- model_3pl_mmle(x$u, true_params=x, iter=40, verbose=TRUE)
}
with(model_3pl_gendata(1000, 20), 
     model_3pl_fitplot(u, t, a, b, c, index=c(1, 3, 5)))
}
\keyword{internal}
