% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/australia.R
\name{get_daily}
\alias{get_daily}
\title{get_daily}
\usage{
get_daily(
  parameter_type,
  station_number,
  start_date,
  end_date,
  var,
  aggregation,
  tz,
  return_fields
)
}
\arguments{
\item{parameter_type}{Parameter value}

\item{station_number}{Station number}

\item{start_date}{Start date (formatted as YYYY-MM-DD) or just the
year (YYYY)}

\item{end_date}{End date (formatted as YYYY-MM-DD) or just the year (YYYY)}

\item{var}{The daily variable of interest. Valid inputs are \code{mean}, \code{min},
\code{max} for continuous series such as discharge and \code{total} for discrete
series such as rainfall and evaporation.}

\item{aggregation}{Whether the data is to be aggregated midnight to
midnight (\verb{24HR}) or from 9am-9am (\verb{09HR}). The default is \verb{24HR}. \verb{09HR}
is only available for mean discharge and total rainfall and evaporation.}

\item{tz}{TZ}

\item{return_fields}{Return fields}
}
\value{
A tibble with the requested return fields. Zero row tibbles are returned if no data is available for the requested dates. The aggregation of data is generally the mean for most variables, except for rainfall and evaporation which is the sum over the chosen period.
}
\description{
get_daily
}
\examples{
# Download daily mean aggregated over the standard day
\dontrun{
get_daily(
  parameter_type = "Water Course Discharge",
  station_number = "410730",
  start_date = "2020-01-01",
  end_date = "2020-01-31",
  var = "mean",
  aggregation = "24HR"
)
}

# Download daily mean aggregated between 9am to 9am
\dontrun{
get_daily(
  parameter_type = "Water Course Discharge",
  station_number = "410730",
  start_date = "2020-01-01",
  end_date = "2020-01-31",
  var = "mean",
  aggregation = "09HR"
)
}

# Download the daily max over the standard day
\dontrun{
get_daily(
  parameter_type = "Water Course Discharge",
  station_number = "410730",
  start_date = "2020-01-01",
  end_date = "2020-01-31",
  var = "max",
  aggregation = "24HR"
)
}

}
