% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{umcsent.example}
\alias{umcsent.example}
\title{University of Michigan Monthly Survey of Consumer Sentiment  & Google Trends Queries}
\format{A data frame with 174 rows and 8 variables with log-transformation
\describe{
  \item{date}{first date of each month in US calendar format}
  \item{consumer.sent}{monthly initial claims of University of Michigan: Consumer Sentiment}
  \item{search.engine}{normalized trend queries retreived from gtrendsR API}
  \item{financial.planning}{normalized trend queries retreived from gtrendsR API}
  \item{bus.news}{normalized trend queries retreived from gtrendsR API}
  \item{investing}{normalized trend queries retreived from gtrendsR API}
  \item{energy.utilities}{normalized trend queries retreived from gtrendsR API}
}}
\usage{
data("umcsent.example")
}
\description{
A dataset containing monthly University of Michigan survey of Consumer Sentiment
along a few related google trend queries Jan from 2014 - June 2018. 
This aims to mimick the dataset from Scott and Varian (2014).
}
\references{
University of Michigan, University of Michigan: Consumer Sentiment [UMCSENT], retrieved from FRED, Federal Reserve Bank of St. Louis; 
\url{https://fred.stlouisfed.org/series/UMCSENT}, November 17, 2018.

Trends queries from google search engine. 
\url{https://trends.google.com/trends/?geo=US}

An interface for retrieving and displaying the information returned online by Google Trends is provided. Trends (number of hits) over the time as well as geographic representation of the results can be displayed.
\url{https://CRAN.R-project.org/package=gtrendsR}

Scott, S. L. and Varian, H. R. (2012). Bayesian Variable Selection for Nowcasting Economic Time Series.
\url{https://www.aeaweb.org/conference/2013/retrieve.php?pdfid=447}
}
\keyword{datasets}
