% Generated by roxygen2 (4.1.0.9000): do not edit by hand
% Please edit documentation in R/searchPeople.R
\name{searchPeople}
\alias{searchPeople}
\title{Search for People on LinkedIn}
\usage{
searchPeople(token, keywords = NULL, first_name = NULL, last_name = NULL,
  company_name = NULL, current_company = NULL, title = NULL,
  current_title = NULL, school_name = NULL, current_school = NULL,
  country_code = NULL, postal_code = NULL, distance = NULL)
}
\arguments{
\item{token}{Authorization token.}

\item{keywords}{A keyword used in a person's profile. Multiple words should be separated by a space.}

\item{first_name}{Search by a user's first name.}

\item{last_name}{Search by a user's last name.}

\item{company_name}{The name of a company where someone has as worked.}

\item{current_company}{TRUE or FALSE, can only be used in conjunction with \code{company_name}.}

\item{title}{A job title someone has held}

\item{current_title}{TRUE or FALSE, can only be used in conjunction with \code{title}.}

\item{school_name}{The name of a school someone has attended.}

\item{current_school}{TRUE or FALSE, can only be used in conjuntion with \code{current_school}.}

\item{country_code}{Specify the country in which to search. This is the ISO3166 country code, and must be in lower case.}

\item{postal_code}{Must be combined with the \code{country_code} parameter.}

\item{distance}{Distance matches members within a distance from a central point. This is measured in miles and and is best used in conjunction with both \code{country_code} and \code{postal-code}.}
}
\value{
Returns a dataframe of people based input parameters
}
\description{
\code{searchPeople} allows you to search for connections on LinkedIn. It returns most of what shows up when you do a search for people in the box at the top of the page on linkedin.com.

There are a number of parameters that allow you to conduct either a broad or focused search.

In order to use this function, you must create your own appliction and apply for the Vetted API Access here: \url{https://help.linkedin.com/app/ask/path/api-dvr}.
}
\examples{
\dontrun{

search.results <- searchPeople(token=in.auth, first_name="Michael", last_name="Piccirilli")
}
}
\author{
Michael Piccirilli \email{michael.r.piccirilli@gmail.com}
}
\seealso{
\code{\link{getProfile}}
}

