% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gomez_modularity_v6_1.R
\name{signed_modularity}
\alias{signed_modularity}
\title{Robust Estimator of modularity (Gomez, et al 2009)}
\usage{
signed_modularity(x, membership, weight = NULL)
}
\arguments{
\item{x}{A graph presented in of the forms discussed below.}

\item{membership}{Defines vertex membership to determine if vertices are similar. May be provided as a string that matches an attribute of x or a vector of length equal to the number of vertices in the graph.}

\item{weight}{Edge weights. Like 'membership', this argument can be defined as a string matching an edge attribute of 'x' or a vector of length equal to the number of edges, but may also be left as NULL which will return an unweighted modularity estimate.}
}
\value{
a numeric value estimating the weighted, signed modularity of x, or a numeric vector containing respective modularity estimates if x contained multiple network.
}
\description{
For flexibility, x may be provided as any of the following formats: an edgelist (data.frame), a weighted adjacency matrix (square numeric matrix), an igraph object, or an rnet.* object (e.g., rnetBasic, rnetMultiStrata, etc.).
}
\details{
Newman's method of estimating graphical modularity based on vertex can accomodate edge weights, but cannot incorporate signed edges, e.g. edges with both positive and negative. Gomez, et al, proposed a similar estimator of modularity estimated in two parts corresponding to positive (Q+) and negative (Q-) edges, and the latter is subtracted from the former. The 'signed_modularity' function implements this method of modularity estimation, and returns a scalar.
}
\examples{
\donttest{
#Signed modularity in a random graph with 10 vertices

x <- sample_gnp(5, 0.4)  #Creates a random graph with 10 vertices and density ~ 40\%
x <- set_edge_attr(x, 'weight', value = runif(gsize(x), -0.5, 0.5))  
     #Randomly assign edge weights to edge attribute 'weight', both positive and negative
x <- set_vertex_attr(x, name = 'group', value = sample(c('red', 'blue'), size = 5, replace = TRUE))

signed_modularity(x, membership = 'group', weight = 'weight')
signed_modularity(x, membership = 'group')

}
}
