% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polygons.R
\name{getCtryPolyAdmLevelNames}
\alias{getCtryPolyAdmLevelNames}
\title{Get the list of admin level names in a polygon shapefile}
\usage{
getCtryPolyAdmLevelNames(ctryCode,
  lowestAdmLevel = getCtryShpLowestLyrNames(ctryCode))
}
\arguments{
\item{ctryCode}{\code{character} The ctryCode of the country of interest}

\item{lowestAdmLevel}{\code{integer} The lowest admin level number to return}
}
\value{
character vector of admin level names
}
\description{
Get the list of admin level names in a polygon shapefile. It returns
    all official names starting from 1 to the specified 
    \code{lowestAdmLevel}. If not \code{lowestAdmLevel} is not
    specified, all admin level names are returned
}
\examples{
\dontrun{
Rnightlights:::getCtryPolyAdmLevelNames("KEN")
#returns vector [1] "County"       "Constituency" "Ward"
#if KEN shapefile exists otherwise errors
}

}
