% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctrynldata.R
\name{allExistsCtryNlData}
\alias{allExistsCtryNlData}
\title{Checks if all data is available}
\usage{
allExistsCtryNlData(ctryCodes, admLevels, nlTypes, configNames,
  multiTileStrategy = pkgOptions("multiTileStrategy"),
  multiTileMergeFun = pkgOptions("multiTileMergeFun"),
  removeGasFlares = pkgOptions("removeGasFlares"), nlPeriods, nlStats,
  gadmVersion = pkgOptions("gadmVersion"),
  gadmPolyType = pkgOptions("gadmPolyType"), custPolyPath = NULL)
}
\arguments{
\item{ctryCodes}{\code{character} vector of ctryCodes to filter by}

\item{admLevels}{A character vector of admLevels to filter by}

\item{nlTypes}{A character vector of nlTypes to filter by}

\item{configNames}{character the type of raster being processed}

\item{multiTileStrategy}{character How to handle multiple tiles per nlPeriod}

\item{multiTileMergeFun}{character The function to use to merge tiles}

\item{removeGasFlares}{logical Whether to perform gas flare removal pre-processing}

\item{nlPeriods}{A character vector of nlPeriods to filter by}

\item{nlStats}{The stats to filter by}

\item{gadmVersion}{The GADM version to use}

\item{gadmPolyType}{The format of polygons to download from GADM}

\item{custPolyPath}{Alternative to GADM. A path to a custom shapefile zip}
}
\value{
TRUE/FALSE
}
\description{
Checks if all data is available
}
