% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplotTools.R
\name{ggplotScores}
\alias{ggplotScores}
\title{ggplotScores}
\usage{
ggplotScores(data, pc1 = 1, pc2 = 2, groups = NULL, EV = NULL,
  main = "Scores", glabels = FALSE, psize = 3,
  gcontour = "ellipse", params = list(cellipse = 0.95))
}
\arguments{
\item{data}{the matrix of scores coming from a multivariable analysis, typically a Principal Component Analysis (PCA)}

\item{pc1}{the fist component of the matrix of variable loadings to be plotted.}

\item{pc2}{the second component of the matrix of variable loadings to be plotted.}

\item{groups}{the vector defining the factorial groups (same dimension as data rows)}

\item{EV}{Eigenvalues vector}

\item{main}{the plot main title}

\item{glabels}{boolean indicating if labels have to be plotted}

\item{psize}{point size}

\item{gcontour}{type of contour; possible values are : 'ellipse', 'polygon', 'ellipse2', 'none'}

\item{params}{parameters depending on the contour type}
}
\description{
Plots the two components defined by pc1, pc2 of the matrix of scores coming from a 
multivariable analysis, typically a Principal Component Analysis (PCA).
}
