% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marginal.R
\name{marginal_plot}
\alias{marginal_plot}
\title{Plots marginal estimates of a fitted RoBMA regression object}
\usage{
marginal_plot(
  x,
  parameter,
  conditional = FALSE,
  plot_type = "base",
  prior = FALSE,
  output_scale = NULL,
  dots_prior = NULL,
  ...
)
}
\arguments{
\item{x}{a fitted RoBMA regression object}

\item{parameter}{regression parameter to be plotted}

\item{conditional}{whether conditional marginal estimates should be
plotted. Defaults to \code{FALSE} which plots the model-averaged
estimates.}

\item{plot_type}{whether to use a base plot \code{"base"}
or ggplot2 \code{"ggplot"} for plotting. Defaults to
\code{"base"}.}

\item{prior}{whether prior distribution should be added to
figure. Defaults to \code{FALSE}.}

\item{output_scale}{transform the effect sizes and the meta-analytic
effect size estimate to a different scale. Defaults to \code{NULL}
which returns the same scale as the model was estimated on.}

\item{dots_prior}{list of additional graphical arguments
to be passed to the plotting function of the prior
distribution. Supported arguments are \code{lwd},
\code{lty}, \code{col}, and \code{col.fill}, to adjust
the line thickness, line type, line color, and fill color
of the prior distribution respectively.}

\item{...}{list of additional graphical arguments
to be passed to the plotting function. Supported arguments
are \code{lwd}, \code{lty}, \code{col}, \code{col.fill},
\code{xlab}, \code{ylab}, \code{main}, \code{xlim}, \code{ylim}
to adjust the line thickness, line type, line color, fill color,
x-label, y-label, title, x-axis range, and y-axis range
respectively.}
}
\value{
\code{plot.RoBMA} returns either \code{NULL} if \code{plot_type = "base"}
or an object object of class 'ggplot2' if \code{plot_type = "ggplot2"}.
}
\description{
\code{marginal_plot} allows to visualize prior and
posterior distributions of marginal estimates of a RoBMA regression model.
}
\seealso{
\code{\link[=RoBMA]{RoBMA()}}
}
