% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IOAORKF.R
\name{IOAORKF}
\alias{IOAORKF}
\title{An innovative and additive outlier robust Kalman filter}
\usage{
IOAORKF(
  Y,
  mu_0,
  Sigma_0 = NULL,
  A,
  C,
  Sigma_Add,
  Sigma_Inn,
  Particles,
  Descendants = 1,
  s = 2,
  anom_add_prob = NULL,
  anom_inn_prob = NULL,
  epsilon = 1e-06,
  horizon_matrix = NULL
)
}
\arguments{
\item{Y}{A list of matrices containing the observations to be filtered.}

\item{mu_0}{A matrix indicating the mean of the prior for the hidden states.}

\item{Sigma_0}{A matrix indicating the variance of the prior for the hidden states. It defaults to the limit of the variance of the Kalman filter.}

\item{A}{A matrix giving the updates for the hidden states.}

\item{C}{A matrix mapping the hidden states to the observed states.}

\item{Sigma_Add}{A positive definite diagonal matrix giving the additive noise covariance.}

\item{Sigma_Inn}{A positive definite diagonal matrix giving the innovative noise covariance.}

\item{Particles}{An integer giving the number of particles to be maintained at each step. More particles lead to more accuracy, but also require more memory and CPU time. The parameter should be at least p + q + 1, where p s the dimension of the observations and q the dimension of the hidden states.}

\item{Descendants}{An integer giving the number of descendants to be sampled for each of the possible anomalies. Increasing Descendants leads to higher accuracy but also higher memory and CPU requirements. The default value is 1.}

\item{s}{A numeric giving the shape of the t-distribution to be considered. It defaults to 2.}

\item{anom_add_prob}{A vector of probabilities with length equal to the dimension of the observations giving the probabilities of additive outliers in each of the components. It defaults to 1/10000.}

\item{anom_inn_prob}{A vector of probabilities with length equal to the dimension of the hidden state giving the probabilities of innovative outliers in each of the components. It defaults to 1/10000.}

\item{epsilon}{A positive numeric giving the precision to which the limit of the covariance is to be computed. It defaults to 0.000001.}

\item{horizon_matrix}{A matrix of 0s and 1s giving the horizon's at which innovative particles are to be resampled. It defaults to a k by q matrix, where k is the number of observations required for observability of the system and q is the dimension of the hidden states.}
}
\value{
An ioaorkf S3 class.
}
\description{
An implementation of Computationally Efficient Bayesian Anomaly detection by Sequential Sampling (CE-BASS) by Fisch et al. (2020).
This function assumes that both the innovations and additions are potentially polluted by a heavy tailed process, which is approximated by a t-distribution.
To approximate the posterior, particles for the precision (inverse variance) are sampled using a robust approximation to the posterior. Conditionally on those samples, the classical Kalman updates are used.
}
\examples{

library(RobKF)

set.seed(2018)

A = diag(2)*0.99
A[1,2] = -0.05
C = matrix(c(10,0.1),nrow=1)
mu = matrix(c(0,0),nrow=2)
Sigma_Inn = diag(c(1,0.01)*0.00001,nrow=2)
Sigma_Add = diag(c(1)*0.1,nrow=1)

Y_list = Generate_Data(100,A,C,Sigma_Add,Sigma_Inn, mu_0 = mu,  anomaly_loc = c(10,30,50), 
                      anomaly_type = c("Inn","Add","Inn"), 
                      anomaly_comp = c(1,1,2),  anomaly_strength = c(400,-10,3000))
                      
horizon_matrix = matrix(1,nrow = 3 ,ncol = 2)

Particle_List = IOAORKF(Y_list,mu,Sigma_0=NULL,A,C,Sigma_Add,Sigma_Inn,Particles=20,
                        horizon_matrix=horizon_matrix)

plot(Particle_List)
summary(Particle_List)


}
\references{
\insertRef{fisch2020innovative}{RobKF}
}
