% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CTLE.short.R
\docType{methods}
\name{CTLE}
\alias{CTLE}
\alias{CTLE,formula,ANY,ANY,numeric-method}
\title{CTLE: Robust mixture regression based on component-wise adaptive trimming likelihood estimation.}
\usage{
CTLE(formula, data, nit = 20, nc = 2)

\S4method{CTLE}{formula,ANY,ANY,numeric}(formula, data, nit = 20,
  nc = 2)
}
\arguments{
\item{formula}{A symbolic description of the model to be fit.}

\item{data}{A data frame containing the predictor and response variables, where the last column is the response varible.}

\item{nit}{Number of iterations.}

\item{nc}{Number of mixture components.}
}
\description{
CTLE performes robust linear regression with high breakdown point and high efficiency in each mixing components and adaptively remove the outlier samples.
}
\examples{
library("RobMixReg")
formula01=as.formula("y~x")
x=(gaussData$x);y=as.numeric(gaussData$y);
example_data01=data.frame(x,y)
res = CTLE(formula01,example_data01, nit=20,nc=2)
}
