% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TLE.short.R
\docType{methods}
\name{TLE}
\alias{TLE}
\alias{TLE,formula,ANY,numeric,numeric,numeric-method}
\alias{CTLE,formula,ANY,numeric,numeric,numeric-method}
\title{TLE: robust mixture regression based on trimmed likelihood estimation.}
\usage{
TLE(formula, data, nc = 2, tRatio, MaxIt = 200)

\S4method{TLE}{formula,ANY,numeric,numeric,numeric}(formula, data,
  nc = 2, tRatio, MaxIt = 200)
}
\arguments{
\item{formula}{A symbolic description of the model to be fit.}

\item{data}{A data frame containing the predictor and response variables, where the last column is the response varible.}

\item{nc}{Number of mixture components.}

\item{tRatio}{Trimming proportion.}

\item{MaxIt}{Maximum iteration.}
}
\value{
A S4 object of RobMixReg class.
}
\description{
The algorithm fits a mixture regression model after trimming a proportion of the observations, given by tRatio.
}
\examples{
library("RobMixReg")
formula01=as.formula("y~x")
x=(gaussData$x);y=as.numeric(gaussData$y);
example_data01=data.frame(x,y)
\donttest{
res = TLE(formula01,example_data01, nc=2,tRatio=0.05,MaxIt=200)
}
}
