#' Alcohol data
#'
#' This data set  contains physicochemical characteristics of 44 aliphatic alcohols.
#' The aim of the experiment was the prediction of the solubility on the basis of
#' molecular descriptors.
#'
#' Format: 44 cases and 7 continuous variables.
#' The columns are:
#' 1. SAG=solvent accessible surface-bounded molecular volume
#' 2. V=volume
#' 3. log PC (PC=octanol–water partitions coefficient)
#' 4. P=polarizability
#' 5. RM=molar refractivity
#' 6. Mass
#' 7. log(Solubility) (response)
#'
#' @docType data
#'
#' @usage data(alcohol)
#'
#' @format An object of class \code{"data.frame"}.
#'
#' @source Romanelli, G.P., Martino, C.M. and Castro, E.A. (2001), Modeling the
#' solubility of aliphatic alcohols via molecular descriptors, Journal of the Chemical
#' Society of Pakistan, 23, 195-199.
#'
#' @examples
#' data(alcohol)
"alcohol"
