% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RFPE.R
\name{lmrobdetMM.RFPE}
\alias{lmrobdetMM.RFPE}
\title{Robust Final Prediction Error}
\usage{
lmrobdetMM.RFPE(object, scale = NULL, bothVals = FALSE)
}
\arguments{
\item{object}{the \code{MM} element (of class \code{\link{lmrob}}) in an object of class \code{\link{lmrobdetMM}}.}

\item{scale}{a numeric value specifying the scale estimate used to compute the RFPE. Usually this 
should be the scale estimate from an encompassing model. If \code{NULL}, the scale estimate in 
\code{object} is used.}

\item{bothVals}{a logical value: if \code{TRUE} the function returns the two terms of the RFPE expression separately (equation 
(5.39) in the reference book); otherwise, the value of RFPE is returned.}
}
\value{
If the argument \code{bothVals} is \code{FALSE}, the robust final prediction error (numeric). Otherwise,
the two terms of the RFPE expression in equation (5.39), Section 5.6.2 of Maronna
et al. (2019), \url{http://www.wiley.com/go/maronna/robust}, are returned separately 
in a list with components named \code{minRhoMM.C} and \code{penaltyRFPE}
}
\description{
This function computes the robust Final Prediction Errors (RFPE) for a robust regression fit using M-estimates.
}
\examples{
data(coleman, package='robustbase')
m2 <- lmrobdetMM(Y ~ ., data=coleman)
lmrobdetMM.RFPE(m2)

}
\references{
\url{http://www.wiley.com/go/maronna/robust}
}
\seealso{
\code{\link{lmrobdetMM}}
}
\author{
Victor Yohai, \email{victoryohai@gmail.com}, Matias Salibian-Barrera, \email{matias@stat.ubc.ca}
}
