% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robincar-SL.R
\name{robincar_SL}
\alias{robincar_SL}
\title{BETA: Covariate adjustment using working models from the super learner libraries
through the AIPW package with cross-fitting.}
\usage{
robincar_SL(
  df,
  treat_col,
  response_col,
  car_strata_cols = NULL,
  covariate_cols = NULL,
  car_scheme = "simple",
  covariate_to_include_strata = NULL,
  SL_libraries = c(),
  SL_learners = c(),
  k_split = 2,
  g_accuracy = 7,
  contrast_h = NULL,
  contrast_dh = NULL
)
}
\arguments{
\item{df}{A data.frame with the required columns}

\item{treat_col}{Name of column in df with treatment variable}

\item{response_col}{Name of the column in df with response variable}

\item{car_strata_cols}{Names of columns in df with car_strata variables}

\item{covariate_cols}{Names of columns in df with covariate variables}

\item{car_scheme}{Name of the type of covariate-adaptive randomization scheme. One of: "simple", "pocock-simon", "biased-coin", "permuted-block".}

\item{covariate_to_include_strata}{Whether to include car_strata variables in covariate adjustment. Defaults to F for ANOVA and ANCOVA; defaults to T for ANHECOVA. User may override by passing in this argument.}

\item{SL_libraries}{Vector of super-learner libraries to use for the covariate adjustment (see \link[SuperLearner:listWrappers]{SuperLearner::listWrappers})}

\item{SL_learners}{Optional list of super-learner "learners" to use for the covariate adjustment (see \link[SuperLearner:create.Learner]{SuperLearner::create.Learner())}}

\item{k_split}{Number of splits to use in cross-fitting}

\item{g_accuracy}{Level of accuracy to check prediction un-biasedness (in digits).}

\item{contrast_h}{An optional function to specify a desired contrast}

\item{contrast_dh}{An optional jacobian function for the contrast (otherwise use numerical derivative)}
}
\value{
See value of \link[RobinCar:robincar_glm]{RobinCar::robincar_glm}, but the working model for \eqn{\hat{\mu}(X_i)} is based on the \link{AIPW} package that uses specified SuperLearner libraries and cross-fitting.
Also, `mod` attribute is an object of class \link[AIPW:AIPW]{AIPW::AIPW}.
}
\description{
Estimate treatment-group-specific response means and (optionally)
treatment group contrasts using a generalized linear working model.
}
\details{
*WARNING: This function is still under development and has not been extensively tested.*
This function currently only works for two treatment groups.
Before using this function, you must load the \link{SuperLearner} library with
`library(SuperLearner)`, otherwise the function call will fail.
}
\examples{

library(SuperLearner)
library(ranger)
n <- 1000
set.seed(10)
DATA2 <- data.frame(A=rbinom(n, size=1, prob=0.5),
                    y=rbinom(n, size=1, prob=0.2),
                    x1=rnorm(n),
                    x2=rnorm(n),
                    x3=as.factor(rbinom(n, size=1, prob=0.5)),
                    z1=rbinom(n, size=1, prob=0.5),
                    z2=rbinom(n, size=1, prob=0.5))
DATA2[, "y"] <- NA
As <- DATA2$A == 1
DATA2[DATA2$A == 1, "y"] <- rbinom(
  sum(As),
  size=1,
  prob=exp(DATA2[As,]$x1)/(1+exp(DATA2[As,]$x1)))
DATA2[DATA2$A == 0, "y"] <- rbinom(
  n-sum(As),
  size=1,
  prob=exp(1 +
    5*DATA2[!As,]$x1 + DATA2[!As,]$x2)/
    (1+exp(1 + 5*DATA2[!As,]$x1 + DATA2[!As,]$x2)))
DATA2$A <- as.factor(DATA2$A)

sl.mod <- robincar_SL(
  df=DATA2,
  response_col="y",
  treat_col="A",
  car_strata_cols=c("z1"),
  covariate_cols=c("x1"),
  SL_libraries=c("SL.ranger"),
  car_scheme="permuted-block",
  covariate_to_include_strata=TRUE
)

sl.mod$result

}
