\name{summary.RuleSetRST}
\alias{summary.RuleSetRST}
\title{The summary function of rules based on RST}
\usage{
\method{summary}{RuleSetRST}(object, ...)
}
\arguments{
  \item{object}{a \code{"RuleSetRST"} object. See
  \code{\link{RI.indiscernibilityBasedRules.RST}}.}

  \item{...}{the other parameters.}
}
\value{
a description that contains the following information:
\itemize{ \item The type of the considered model. \item The
type of the considered method. \item The type of the
considered task. \item The rules. Every rule constitutes
two parts which are IF and THEN parts.  For example,
\code{"IF pres is around 90 and preg is around 8 THEN class
is 2; (support=4;laplace=0.67)"}. }
}
\description{
This function enables the output of a summary of the rule
induction methods.
}
\examples{
###########################################################
## Example : Classification problem
###########################################################
data(RoughSetData)
decision.table <- RoughSetData$hiring.dt

## determine feature subset/reduct
reduct <- FS.permutation.heuristic.reduct.RST(decision.table,  permutation = NULL)

rules <- RI.indiscernibilityBasedRules.RST(decision.table, reduct)

summary(rules)
}

