% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BasicRoughSets.R
\name{BC.IND.relation.RST}
\alias{BC.IND.relation.RST}
\title{Computation of indiscernibility classes based on the rough set theory}
\usage{
BC.IND.relation.RST(decision.table, feature.set = NULL)
}
\arguments{
\item{decision.table}{an object inheriting from the \code{"DecisionTable"} class, which represents a decision system. 
See \code{\link{SF.asDecisionTable}}.}

\item{feature.set}{an integer vector indicating indexes of attributes which should be used or an object inheriting from
the \code{FeatureSubset} class.
The computed indiscernibility classes will be relative to this attribute set. 
The default value is \code{NULL} which means that 
all conditional attributes should be considered. It is usually reasonable 
to discretize numeric attributes before the computation of indiscernibility classes.}
}
\value{
An object of a class \code{"IndiscernibilityRelation"} which is a list with the following components:
         \itemize{
         \item \code{IND.relation}: a list of indiscernibility classes in the data. Each class is represented by indices 
               of data instances which belong to that class
         \item \code{type.relation}: a character vector representing a type of relation used in computations. Currently, 
               only \code{"equivalence"} is provided. 
         \item \code{type.model}: a character vector identifying the type of model which is used. 
               In this case, it is \code{"RST"} which means the rough set theory.
         }
}
\description{
This function implements a fundamental part of RST: the indiscernibility relation.
This binary relation indicates whether it is possible to discriminate any given pair of objects from an information system. 
 
This function can be used as a basic building block for development of other RST-based methods.
A more detailed explanation of the notion of indiscernibility relation can be found in \code{\link{A.Introduction-RoughSets}}.
}
\examples{
#############################################
data(RoughSetData)
hiring.data <- RoughSetData$hiring.dt

## In this case, we only consider the second and third attribute:
A <- c(2,3)
## We can also compute a decision reduct:
B <- FS.reduct.computation(hiring.data)

## Compute the indiscernibility classes:
IND.A <- BC.IND.relation.RST(hiring.data, feature.set = A)
IND.A

IND.B <- BC.IND.relation.RST(hiring.data, feature.set = B)
IND.B

}
\references{
Z. Pawlak, "Rough Sets", International Journal of Computer and Information Sciences, 
vol. 11, no. 5, p. 341 - 356 (1982).
}
\seealso{
\code{\link{BC.LU.approximation.RST}}, \code{\link{FS.reduct.computation}}, \code{\link{FS.feature.subset.computation}}
}
\author{
Andrzej Janusz
}
