% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.add.R
\name{filters.add}
\alias{filters.add}
\title{Add a new filter}
\usage{
filters.add(name, conditions, type, api_token = NULL,
  company_domain = "api", return_type = c("complete", "boolean"))
}
\arguments{
\item{name}{Filter name}

\item{conditions}{Filter conditions as a JSON object. It requires a minimum structure as follows: {glue:and,conditions:[{glue:and,conditions: [CONDITION_OBJECTS]},{glue:or,conditions:[CONDITION_OBJECTS]}]}. Replace CONDITION_OBJECTS with JSON objects of the following structure: {object:,field_id:, operator:,value:, extra_value:} or leave the array empty.}

\item{type}{Type of filter to create. This field has the following domains: (deals; org; people; products; activity)}

\item{api_token}{To validate your requests, you'll need your api_token - this means that our system will need to know who you are and be able to connect all actions you do with your chosen Pipedrive account. Have in mind that a user has a different api_token for each company. Please access the following link for more information: <https://pipedrive.readme.io/docs/how-to-find-the-api-token?utm_source=api_reference>}

\item{company_domain}{How to get the company domain: <https://pipedrive.readme.io/docs/how-to-get-the-company-domain>}

\item{return_type}{the default return is an object List with all informations of process, or you can set boolean (TRUE = success, FALSE = error)}
}
\value{
customizable return, the default is an object List
}
\description{
Function to Add a new filter on pipedrive.
}
\examples{
\donttest{
filters.add(name='e.g.',conditions='e.g.',type='e.g.',api_token='token',company_domain='exp')
}
}
