% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mailthreads.get_all.R
\name{mailthreads.get_all}
\alias{mailthreads.get_all}
\title{Get mail threads}
\usage{
mailthreads.get_all(folder, start = NULL, limit = NULL,
  api_token = NULL, company_domain = "api")
}
\arguments{
\item{folder}{Type of folder to fetch. This field has the following domains: (inbox; drafts; sent; archive)}

\item{start}{Index of the first item. If not set, then equals 0.}

\item{limit}{Amount of threads to fetch. If not set, then equals 50.}

\item{api_token}{To validate your requests, you'll need your api_token - this means that our system will need to know who you are and be able to connect all actions you do with your chosen Pipedrive account. Have in mind that a user has a different api_token for each company. Please access the following link for more information: <https://pipedrive.readme.io/docs/how-to-find-the-api-token?utm_source=api_reference>}

\item{company_domain}{How to get the company domain: <https://pipedrive.readme.io/docs/how-to-get-the-company-domain>}
}
\value{
return an object List()
}
\description{
Function to Get mail threads from pipedrive.
}
\examples{
\donttest{
mailthreads.get_all(folder='e.g.',api_token='token',company_domain='exp')
}
}
