% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RprobitB_data.R
\name{RprobitB_data}
\alias{RprobitB_data}
\title{Create object of class \code{RprobitB_data}.}
\usage{
RprobitB_data(
  data,
  choice_data,
  N,
  T,
  J,
  P_f,
  P_r,
  alternatives,
  form,
  re,
  ASC,
  linear_coeffs,
  standardize,
  simulated,
  choice_available,
  true_parameter
)
}
\arguments{
\item{data}{A list with the choice data.
The list has \code{N} elements.
Each element is a list with two elements, \code{X} and \code{y}, which are
the covariates and decisions for a decision maker. More precisely,
\code{X} is a list of \code{T} elements, where each element is a matrix of
dimension \code{J}x(\code{P_f}+\code{P_r}) and contains the characteristics
for one choice occasion.
\code{y} is a vector of length \code{T} and contains the labels for the
chosen alternatives.}

\item{choice_data}{A data frame of choice data in "wide" format (i.e. each row represents
one choice occasion) with the following requirements:
\itemize{
\item It must contain a column named \code{id} which contains unique
identifier for each decision maker.
\item It can contain a column named \code{choice} with the observed
choices, where \code{choice} must match the name of the dependent
variable in \code{form}.
Such a column is required for model fitting but not for prediction.
\item For each alternative specific covariate \emph{p} in \code{form} and each
choice alternative \emph{j} in \code{alternatives}, \code{choice_data}
must contain a column named \emph{p_j}.
\item For each covariate \emph{q} in \code{form} that is constant across
alternatives, \code{choice_data} must contain a column named \emph{q}.
}}

\item{N}{The number (greater or equal 1) of decision makers.}

\item{T}{The number (greater or equal 1) of choice occasions or a vector of choice
occasions of length \code{N} (i.e. a decision maker specific number).}

\item{J}{The number (greater or equal 2) of choice alternatives.}

\item{P_f}{The number of covariates connected to a fixed coefficient (can be 0).}

\item{P_r}{The number of covariates connected to a random coefficient (can be 0).}

\item{alternatives}{A character vector with the names of the choice alternatives.
If not specified, the choice set is defined by the observed choices.}

\item{form}{A formula object that is used to specify the probit model.
The structure is \code{choice ~ A | B | C}, where
\itemize{
\item \code{A} are names of alternative and choice situation specific
covariates with a generic coefficient,
\item \code{B} are names of choice situation specific covariates with
alternative specific coefficients,
\item and \code{C} are names of alternative and choice situation specific
covariates with alternative specific coefficients.
}
Separate multiple covariates of one type by a \code{+} sign.
By default, alternative specific constants (ASCs) are added to the model
(for all except for the last alternative).
They can be removed by adding \code{+0} in the second spot.
See the vignette \code{vignette("data_management", package = "RprobitB")}
for more details.}

\item{re}{A character (vector) of covariates of \code{form} with random effects.
If \code{re = NULL} (the default), there are no random effects.
To have random effects for the alternative specific constants, include
\code{"ASC"} in \code{re}.}

\item{ASC}{A boolean, determining whether the model has ASCs.}

\item{linear_coeffs}{A data frame with the coefficient names and booleans indicating whether
they are connected to random effects.}

\item{standardize}{A character vector of names of covariates that get standardized.
Covariates of type 1 or 3 have to be addressed by
\code{<covariate>_<alternative>}.
If \code{standardize = "all"}, all covariates get standardized.}

\item{simulated}{A boolean, if \code{TRUE} then \code{data} is simulated, otherwise
\code{data} is empirical.}

\item{choice_available}{A boolean, if \code{TRUE} then \code{data} contains observed choices.}

\item{true_parameter}{An object of class \code{RprobitB_parameters}.}
}
\value{
An object of class \code{RprobitB_data} with the arguments of this function
as elements.
}
\description{
This function creates an object of class \code{RprobitB_data}.
}
\keyword{s3}
