% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_initial_gibbs_values.R
\name{set_initial_gibbs_values}
\alias{set_initial_gibbs_values}
\title{Set initial values for the Gibbs sampler.}
\usage{
set_initial_gibbs_values(N, T, J, P_f, P_r, C)
}
\arguments{
\item{N}{The number (greater or equal 1) of decision makers.}

\item{T}{The number (greater or equal 1) of choice occasions or a vector of choice
occasions of length \code{N} (i.e. a decision maker specific number).}

\item{J}{The number (greater or equal 2) of choice alternatives.}

\item{P_f}{The number of covariates connected to a fixed coefficient (can be 0).}

\item{P_r}{The number of covariates connected to a random coefficient (can be 0).}

\item{C}{The number (greater or equal 1) of latent classes.}
}
\value{
A list of initial values for the Gibbs sampler.
}
\description{
This function sets initial values for the Gibbs sampler.
}
\keyword{internal}
