% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{transform}
\alias{transform}
\title{Change the length of the burn-in period, the thinning factor and the scale
after Gibbs sampling.}
\usage{
transform(x, B = NULL, Q = NULL, scale = NULL, check_preference_flip = TRUE)
}
\arguments{
\item{x}{An object of class \code{\link{RprobitB_model}}.}

\item{B}{The length of the burn-in period, i.e. a non-negative number of samples to
be discarded.}

\item{Q}{The thinning factor for the Gibbs samples, i.e. only every \code{Q}th
sample is kept.}

\item{scale}{A named list of three elements, determining the parameter normalization with
respect to the utility scale:
\itemize{
\item \code{parameter}:
Either \code{"a"} (for a linear coefficient of \code{"alpha"}) or
\code{"s"} (for a variance of the error-term covariance matrix
\code{"Sigma"}).
\item \code{index}:
The index of the parameter that gets fixed.
\item \code{value}:
The value for the fixed parameter.
}}

\item{check_preference_flip}{If \code{TRUE} check for flip in preferences with new scale.}
}
\value{
An object of class \code{RprobitB_model}.
}
\description{
Given an object of class \code{RprobitB_model}, this function can:
\itemize{
\item change the length \code{B} of the burn-in period,
\item change the the thinning factor \code{Q} of the Gibbs samples,
\item change the model \code{scale}.
}
}
\details{
See the vignette "Model fitting" for more details:
\code{vignette("model_fitting", package = "RprobitB")}.
}
