% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exp_est.R
\name{exp_est}
\alias{exp_est}
\title{Export wave objects of extended selection tables as sound files}
\usage{
exp_est(X, file.name = NULL, path = NULL, single.file = FALSE, 
selection.table = TRUE, pb = TRUE, normalize = TRUE, parallel = 1, wave.object = FALSE)
}
\arguments{
\item{X}{object of class 'extended_selection_table' (objects produced by \code{\link[warbleR]{selection_table}}). More details about these objects can be found on \href{https://marce10.github.io/warbleR/articles/annotation_data_format.html#extended-selection-tables}{this link}.}

\item{file.name}{character string indicating the name of the sound file (if \code{single.file = TRUE}) 
and/or the selection table (if \code{selection.table = TRUE}). Default is \code{NULL}.}

\item{path}{A character string indicating the path of the directory where sound files and/or selection table will be saved. If not provided the
function uses the current working directory. Default is \code{NULL}.}

\item{single.file}{Logical argument to control if all wave objects are pooled together in a 
single sound file (if \code{TRUE}) or each one as an individual sound file (if \code{FALSE}, default). If 
exporting a single sound file the files are pasted in the same sequences as in the extended selection table. Note that to create a single sound file ALL WAVE OBJECTS IN 'X" MUST HAVE THE SAME SAMPLE RATE (check \code{attributes(X)$check.res$sample.rate}) and ideally the same bit depth (although not strictly required). If that is not the case, sample rate can be homogenize using the \code{\link[warbleR]{resample_est}} from the warbleR package.}

\item{selection.table}{Logical argument to determine if a Raven sound selection table ('.txt' file) is also exported. 
Default is \code{TRUE}. If \code{FALSE} then selection table is return as an object in the R environment. If exporting multiple sound files (if \code{single.file = FALSE}) the function still exports a single selection table (in this case a multiple sound selection table).}

\item{pb}{Logical argument to control progress bar when exporting multiple sound files. Default is \code{TRUE}.}

\item{normalize}{Logical argument to control if wave objects are individually normalized before exporting (or before being pasted together if \code{single.file = TRUE}). Normalization rescales amplitude values to a 16 bit dynamic range. Default is \code{FALSE}.}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing).}

\item{wave.object}{Logical argument to control if ONLY a single wave object is returned in the R environment (TRUE) instead of a wave file in the working directory (and a selection table if \code{selection.table = TRUE}). Default is \code{FALSE}.}
}
\value{
Sound file(s) are saved in the provided path or current working directory. If \code{selection.table = TRUE} a Raven sound selection table with the data in 'X' will also be saved.
}
\description{
\code{exp_est} exports wave objects of an extended selection table as sound files
}
\details{
The function takes wave objects contained as attributes in extended selection 
tables and saves them as sound files in '.wav' format. A single or several sound files can be produced (see 'single.file' argument).  In addition, a Raven sound selection table can be saved along with the sound files. The exported selection table can be open in Raven for exploring/manipulating selections in 'X'.
}
\examples{
\dontrun{
# load example data
data(list = "lbh.est", package = "NatureSounds")

# subset to 10 selections
X <- lbh.est[1:10, ]

# Export data to a single sound file
exp_est(X, file.name = "test", single.file = TRUE, path = tempdir())

# Export data to a single sound file and normalizing, no pb
exp_est(X, file.name = "test2", single.file = TRUE, normalize = TRUE, pb = FALSE, path = tempdir())

# several files
exp_est(X, single.file = FALSE, file.name = "test3", path = tempdir())
}
}
\seealso{
\code{\link{exp_raven}}
}
\author{
Marcelo Araya-Salas (\email{marcelo.araya@ucr.ac.cr})
}
