% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rsagacmd.R
\docType{package}
\name{Rsagacmd}
\alias{Rsagacmd}
\title{Rsagacmd: Linking R with the open-source SAGA-GIS software.}
\description{
\pkg{Rsagacmd} provides an R scripting interface to the open-source System
for Automated Geoscientific Analyses Geographical Information System software
\href{https://sourceforge.net/projects/saga-gis/}{SAGA-GIS}. The current
version has been tested using SAGA-GIS versions 2.3.1 to 7.9.0 on Windows
(x64), OS X and Linux. Rsagacmd provides a functional approach to scripting
with SAGA-GIS by dynamically generating R functions for every SAGA-GIS tool
based on the user's current SAGA-GIS installation. These functions are
generated by the \code{\link{saga_gis}} function and are included within an
S3 object as a named list of libraries and tools. This structure facilitates
an easier scripting experience by organizing the large number of SAGA-GIS
tools (>700) by their respective library. Interactive scripting can also
fully take advantage of code autocompletion tools (e.g. in
\href{https://www.rstudio.com}{Rstudio}), allowing for each tool's syntax to be
quickly recognized. Furthermore, the most common types of spatial data
(rasters using the \pkg{raster} package, and vector data using the \pkg{sp}
or simple features \pkg{sf} packages) along with non-spatial data are
seamlessly passed from R to the SAGA-GIS command line tool for geoprocessing
operations, and the results are automatically loaded as the appropriate R
object. Outputs from individual SAGA-GIS tools can also be chained using
pipes from the \pkg{magrittr} and \pkg{dplyr} packages to chain complex
geoprocessing operations together in a single statement.
}
\section{Handling of geospatial and tabular data}{
 Rsagacmd aims to facilitate
  a seamless interface to the open-source SAGA-GIS by providing access to all
  SAGA-GIS geoprocessing tools in a 'R-like' manner. In addition to
  generating R functions that correspond to each SAGA-GIS tool, Rsagacmd
  automatically handles the passing of geospatial and tabular data contained
  from the R environment to SAGA-GIS.

Rsagacmd uses the SAGA-GIS command line interface to perform geoprocessing
operations. Therefore, spatial data can be passed to any Rsagacmd function as
a path to the input data, assuming that the data is stored in the appropriate
file formats (e.g. GDAL-supported single-band rasters, OGR supported vector
data, and comma- or tab-delimited text files for tabular data). In addition,
Rsagacmd also supports the following R object classes to pass data to
SAGA-GIS, and to load the results back into the R environment:
\itemize{
\item Raster data handling is provided by the R \pkg{raster} package
Raster-based outputs from SAGA-GIS tools are loaded as RasterLayer objects.
For more details, see the 'Handling of raster data'.
\item Vector features that result from SAGA-GIS geoprocessing operations are
output in ESRI Shapefile format and are loaded into the R environment as
simple features objects
\item Tabular data from SAGA-GIS tools are loaded as data frames
}
The results from tools that return multiple outputs are loaded into the R
environment as a named list of the appropriate R object classes.
}

\section{Multi-band raster data and RasterStack/RasterBrick objects}{
 SAGA-GIS
  does not handle multi-band rasters and the native SAGA GIS Binary file
  format (.sgrd) supports only single band data. Therefore when passing
  raster data to most SAGA-GIS tools using Rsagacmd, the data should
  represent single raster bands, specified as either the path to the single
  raster band, or when using the R \pkg{raster} package, a RasterLayer (or
  less commonly a RasterStack or RasterBrick) object that contains only a
  single layer. Subsetting of raster data is performed automatically by
  Rsagacmd in the case of when a single band from a RasterStack or
  RasterBrick object is passed to a SAGA-GIS tool. This occurs in by either
  passing the filename of the raster to the SAGA-GIS command line, or by
  writing the data to a temporary file. A few SAGA-GIS functions will accept
  a list of single band rasters as an input. In this case if this data is in
  the form of a RasterStack or RasterLayer object, it is recommended to use
  pass the output from the unstack function in the \pkg{raster} package,
  which will return a list of RasterLayer objects, and then Rsagacmd will
  handle the subsetting automatically.
}

\section{Combining SAGA-GIS tools with pipes}{
 For convenience, outputs from
  SAGA-GIS tools are automatically saved to tempfiles if outputs are not
  explicitly stated as arguments when calling the function. This was
  implemented so that the user can create complex workflows based on little
  code. It is also means that several processing steps can be combined or
  chained in a convenient manner using pipes from the \pkg{magritrr} package.
  When using pipes, all of the intermediate processing steps are dealt with
  automatically by saving the outputs as tempfiles, and then in turn passing
  the output to the next function in the chain. Note that when dealing with
  high-resolution and/or larger raster data, these tempfiles can start to
  consume a significant amount of disk space during a session. If required,
  these temporary files can be cleaned during the session in a similar way to
  the raster package, using the saga_remove_tmpfiles function.
}

\examples{
\dontrun{
library(Rsagacmd)
library(magrittr)

# initialize a saga object
saga <- saga_gis(opt_lib = c("grid_calculus", "ta_morphometry"))

# example of executing a tool using a tempfile to store the tool outputs
dem <- saga$grid_calculus$random_terrain(radius = 100, iterations = 500)

# Example of chaining operations using pipes and using tempfile to
# store tool outputs
tri <- dem \%>\%
  saga$ta_morphometry$terrain_ruggedness_index_tri()

# Remove tempfiles generated by Rsagacmd during a session
saga_remove_tmpfiles(h = 0)
}

}
\author{
Steven Pawley, \email{dr.stevenpawley@gmail.com}
}
