% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testmlx.R
\name{testmlx}
\alias{testmlx}
\title{Statistical tests for model assessment}
\usage{
testmlx(project, tests = c("covariate", "randomEffect", "correlation",
  "residual"), plot = FALSE)
}
\arguments{
\item{project}{a Monolix project}

\item{tests}{a vector of strings: the list of tests to perform 
among c("covariate","randomEffect","correlation","residual")}

\item{plot}{{FALSE}/TRUE  display some diagnostic plots associated to the tests (default=FALSE)}
}
\value{
a list of data frames and ggplot objects if plot=TRUE
}
\description{
Perform several statistical tests using the results of a Monolix run to assess the statistical
components of the model in use.
}
\details{
The tests used are:  1) F-tests (or, equivalently, correlation tests) to evaluate the effect of 
each covariate on each parameter ("covariate"), 2) Shapiro-Wilk and symmetry tests to assess 
the distribution of the random effects (""randomEffect"), 3) correlation tests to assess the 
correlation structure of the random effects ("correlation"), 4) Shapiro-Wilk and symmetry 
tests to assess the distribution of the residual errors ("residual").

By default, the four tests are performed
}
\examples{
initializeMlxConnectors(software = "monolix")

# RsmlxDemo2.mlxtran is a Monolix project for modelling the PK of warfarin using a PK model 
# with parameters ka, V, Cl.

#testmlx will perform statistical tests for the different component of the statistical model:
r1 <- testmlx(project="RsmlxDemo2.mlxtran")

#testmlx will perform statistical tests for the covariate model and the correlation model only.
r2 <- testmlx(project="RsmlxDemo2.mlxtran", tests=c("covariate","correlation"))

# See http://rsmlx.webpopix.org/userguide/testmlx/ for detailed examples of use of testmlx
# Download the demo examples here: http://rsmlx.webpopix.org/Rsmlx/Rsmlx10_demos.zip
}
