% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setSettings.R
\name{setSettings}
\alias{setSettings}
\title{Easy tuning of the settings of a Monolix project}
\usage{
setSettings(project = NULL, new.project = NULL, level = 5)
}
\arguments{
\item{project}{a string: a Monolix project (the loaded project if NULL)}

\item{new.project}{a string: the new created Monolix project (default is the original project)}

\item{level}{an integer between 1 and 9 (default=5)}
}
\description{
Use a single accuracy level, between 1 and 9, to automatically tune all the settings  
of a Monolix project.
When the accuray level is equal to 1, the algorithms are very fast but the results may be
not precise.  When the accuray level is equal to 9, the algorithms are slow but the results 
are accurate. Default Monolix settings are obtained with level=5.
}
\examples{
\dontrun{
# RsmlxDemo1.mlxtran is a Monolix project for modelling the PK of warfarin.
# All settings of the project are set so that algorithms used by Monolix converge as 
# quickly as possible possible:
setSettings(project="RsmlxDemo1.mlxtran", level=1)

# A new project will be created with settings set in order to obtain the most 
# precise results possible:
new.project= file.path(tempdir(),"RsmlxDemoNew.mlxtran")
setSettings(project="RsmlxDemo1.mlxtran", new.project=new.project, level=9)

# See http://monolix.lixoft.com/rsmlx/setSettings/ for detailed examples of use of setSettings
# Download the demo examples here: http://monolix.lixoft.com/rsmlx/installation
}
}
