% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benchmark_suite.R
\name{solnp_problem_suite}
\alias{solnp_problem_suite}
\title{Retrieve Implemented Test Problems for the SOLNP Suite}
\usage{
solnp_problem_suite(
  suite = "Hock-Schittkowski",
  number = 1,
  return_all = FALSE
)
}
\arguments{
\item{suite}{Character. The test suite to draw from. Must be one of \dQuote{Hock-Schittkowski} or \dQuote{Other}.
Default is \dQuote{Hock-Schittkowski}.}

\item{number}{Integer or vector of integers. One or more problem numbers to retrieve. Ignored if return_all = TRUE.}

\item{return_all}{Logical. If TRUE, returns all implemented problems in the specified suite. Default is FALSE.}
}
\value{
If one problem is requested and implemented, the evaluated problem object is returned directly.
Otherwise, an unnamed list of evaluated problem objects is returned.
}
\description{
Returns a list (or a single object) of implemented test problems corresponding to a selected suite.
Problem functions must follow the naming convention \sQuote{problem_name_problem} and return a list
describing the optimization problem (e.g., objective, constraints, bounds).
}
\details{
\itemize{
\item Problems are matched by number within the selected suite, using the table from \code{\link[=solnp_problems_table]{solnp_problems_table()}}.
\item If a requested problem is valid but not yet implemented (i.e., the corresponding function does not exist),
a message will inform the user.
\item If a problem number exceeds the allowable range (e.g., > 306 for Hock-Schittkowski), an error is raised.
}
}
\examples{
\dontrun{
# Retrieve a single HS problem
prob <- solnp_problem_suite(number = 1)

# Retrieve multiple HS problems
probs <- solnp_problem_suite(number = c(1, 2, 3))

# Retrieve problem in "Other" suite
other_prob <- solnp_problem_suite(suite = "Other", number = 1)
}

}
\seealso{
\code{\link[=solnp_problems_table]{solnp_problems_table()}}
}
