% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DefineAndUpdateVariables.R
\name{ConvertStoxAcoustic}
\alias{ConvertStoxAcoustic}
\title{Convert StoxAcousticData}
\usage{
ConvertStoxAcoustic(
  StoxAcousticData,
  TargetVariable = character(),
  ConversionFunction = c("Constant", "Addition", "Scaling", "AdditionAndScaling"),
  GruopingVariables = character(),
  Conversion = data.table::data.table()
)
}
\arguments{
\item{StoxAcousticData}{An input of \link{ModelData} object

The parameters of the \code{ConversionFunction} are "Constant" for ConversionFunction "Constant", "Addition" for ConversionFunction"Addition", "Scaling" for ConversionFunction "Scaling", and "Addition" and "Scaling" for ConversionFunction "AdditionAndScaling".}

\item{TargetVariable}{The variable to modify.}

\item{ConversionFunction}{Character: The function to convert by, one of "Constant", for replacing the specified columns by a constant value; "Addition", for adding to the columns; "Scaling", for multiplying by a factor; and "AdditionAndScaling", for both adding and multiplying.}

\item{GruopingVariables}{A vector of variables to specify in the \code{Conversion}. The parameters specified in the table are valid for the combination of the \code{GruopingVariables} in the data.}

\item{Conversion}{A table of the \code{GruopingVariables} and the columns "TargetVariable", "SourceVariable" and the parameters of the \code{ConversionFunction} (see details).

The parameters of the \code{ConversionFunction} are "Constant" for ConversionFunction "Constant", "Addition" for ConversionFunction"Addition", "Scaling" for ConversionFunction "Scaling", and "Addition" and "Scaling" for ConversionFunction "AdditionAndScaling".}
}
\value{
A \code{\link{StoxAcousticData}} object.
}
\description{
This function converts one or more columns of \code{\link{StoxAcousticData}} by the function given by \code{ConversionFunction}.
}
