% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/vcgGetEdge.r
\name{vcgNonBorderEdge}
\alias{vcgNonBorderEdge}
\title{Get all non-border edges}
\usage{
vcgNonBorderEdge(mesh, silent = FALSE)
}
\arguments{
\item{mesh}{triangular mesh of class 'mesh3d}

\item{silent}{logical: suppress output of information about number of border edges}
}
\value{
returns a dataframe containing:
\item{vert1}{integer indicating the position of the first vertex belonging to this edge}
\item{vert2}{integer indicating the position of the second vertex belonging to this edge}
\item{border}{integer indicating if the edge is at the border of the mesh. 0 = no border, 1 = border}
\item{face1 }{integer pointing to the first face adjacent to the edge}
\item{face2 }{integer pointing to the first face adjacent to the edge}
}
\description{
Get all non-border edges and both faces adjacent to them.
}
\examples{
data(humface)
edges <-vcgNonBorderEdge(humface)
## show first edge (not at the border)
\dontrun{
require(Morpho)
require(rgl)
lines3d(t(humface$vb[1:3,])[c(edges$vert1[1],edges$vert2[2]),],col=2,lwd=3)

## plot barycenters of adjacent faces
bary <- barycenter(humface)
points3d(bary[c(edges$face1[1],edges$face2[1]),])
shade3d(humface, col=3)
## now find the edge - hint: it is at the neck.
}
}
\seealso{
\code{\link{vcgGetEdge}}
}

