% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcgMetro.r
\name{vcgMetro}
\alias{vcgMetro}
\title{evaluate the difference between two triangular meshes.}
\usage{
vcgMetro(mesh1, mesh2, nSamples = 0, nSamplesArea = 0, vertSamp = TRUE,
  edgeSamp = TRUE, faceSamp = TRUE, unrefVert = FALSE,
  samplingType = c("SS", "MC", "SD"), searchStruct = c("SGRID", "AABB",
  "OCTREE", "HGRID"), from = 0, to = 0, colormeshes = FALSE,
  silent = FALSE)
}
\arguments{
\item{mesh1}{triangular mesh (object of class 'mesh3d').}

\item{mesh2}{triangular mesh (object of class 'mesh3d').}

\item{nSamples}{set the required number of samples if 0, this will be set to approx. 10x the face number.}

\item{nSamplesArea}{set the required number of samples per area unit, override nSamples.}

\item{vertSamp}{logical: if FALSE, disable vertex sampling.}

\item{edgeSamp}{logical: if FALSE, disable edge sampling.}

\item{faceSamp}{logical: if FALSE, disable face sampling.}

\item{unrefVert}{logical: if FALSE, ignore unreferred vertices.}

\item{samplingType}{set the face sampling mode. options are: SS (similar triangles sampling), SD (subdivision sampling), MC (montecarlo sampling).}

\item{searchStruct}{set search structures to use. options are: SGIRD (static Uniform Grid), OCTREE, AABB (AxisAligned Bounding Box Tree), HGRID (Hashed Uniform Grid).}

\item{from}{numeric: minimum value for color mapping.}

\item{to}{numeric: maximum value for color mapping.}

\item{colormeshes}{if TRUE, meshes with vertices colored according to distance are returned}

\item{silent}{logical: if TRUE, output to console is suppressed.}
}
\value{
\item{ForwardSampling, BackwardSampling}{lists containing information about forward (mesh1 to mesh2) and backward (mesh2 to mesh1) sampling with the following entries}
\itemize{
\item{ \code{maxdist} maximal Hausdorff distance}
\item{ \code{meandist} mean Hausdorff distance}
\item{ \code{RMSdist} RMS of the Hausdorff distances}
\item{ \code{area} mesh area (of \code{mesh1} in \code{ForwardSampling} and  \code{mesh2} in  \code{BackwardSampling})}
\item{ \code{RMSdist} RMS of the Hausdorff distances}
\item{ \code{nvbsamples} number of vertices sampled}
\item{ \code{nsamples} number of samples}
}
\item{distances1, distances2}{vectors containing vertex distances from mesh1 to mesh2 and mesh2 to mesh1.}
\item{forward_hist, backward_hist}{Matrices tracking the sampling results}
if colormeshes == TRUE
\item{mesh1, mesh2}{meshes with color coded distances and an additional entry called quality containing the sampled per-vertex distances}
}
\description{
Implementation of the command line tool "metro" to evaluate the difference between two triangular meshes.
}
\note{
this is a straightforward implementation of the command line tool metro \url{http://vcg.isti.cnr.it/vcglib/metro.html}
}
\examples{
require(Morpho)
data(humface)
data(dummyhead)
## align humface to dummyhead.mesh
humfalign <- rotmesh.onto(humface,humface.lm,dummyhead.lm)
samp <- vcgMetro(humfalign$mesh,dummyhead.mesh,faceSamp=FALSE,edgeSamp=FALSE)
## create heatmap using Morpho's meshDist function
\dontrun{
## create custom heatmaps based on distances
mD <- meshDist(humfalign$mesh,distvec=samp$distances1)
}
}
\references{
P. Cignoni, C. Rocchini and R. Scopigno. Metro: measuring error on simplified surfaces. Computer Graphics Forum, Blackwell Publishers, vol. 17(2), June 1998, pp 167-174
}
