% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rxsolve.R
\name{rxSolve}
\alias{rxSolve}
\alias{rxSolve.RxODE}
\alias{rxSolve.solveRxODE}
\title{Solves a ODE equation}
\usage{
rxSolve(object, params = NULL, events = NULL, inits = NULL, scale = c(),
  covs = NULL, stiff = TRUE, transit_abs = NULL, atol = 1e-06,
  rtol = 1e-06, maxsteps = 5000, hmin = 0, hmax = NULL, hini = 0,
  maxordn = 12, maxords = 5, ..., covs_interpolation = c("linear",
  "constant"), theta = numeric(), eta = numeric(), add.cov = FALSE)

\method{rxSolve}{RxODE}(object, params = NULL, events = NULL,
  inits = NULL, scale = c(), covs = NULL, stiff = TRUE,
  transit_abs = NULL, atol = 1e-08, rtol = 1e-06, maxsteps = 5000,
  hmin = 0, hmax = NULL, hini = 0, maxordn = 12, maxords = 5, ...,
  covs_interpolation = c("linear", "constant"), theta = numeric(),
  eta = numeric(), matrix = FALSE, add.cov = FALSE)

\method{rxSolve}{solveRxODE}(object, params = NULL, events = NULL,
  inits = NULL, scale = c(), covs = NULL, stiff = TRUE,
  transit_abs = NULL, atol = 1e-08, rtol = 1e-06, maxsteps = 5000,
  hmin = 0, hmax = NULL, hini = 0, maxordn = 12, maxords = 5, ...,
  covs_interpolation = c("linear", "constant"), theta = numeric(),
  eta = numeric(), matrix = FALSE, add.cov = FALSE)
}
\arguments{
\item{object}{is a either a RxODE family of objects, or a file-name
with a RxODE model specification, or a string with a RxODE
model specification.}

\item{params}{a numeric named vector with values for every
parameter in the ODE system; the names must correspond to the
parameter identifiers used in the ODE specification;}

\item{events}{an \code{eventTable} object describing the input
(e.g., doses) to the dynamic system and observation sampling
time points (see \code{\link{eventTable}});}

\item{inits}{a vector of initial values of the state variables
(e.g., amounts in each compartment), and the order in this
vector must be the same as the state variables (e.g., PK/PD
compartments);}

\item{scale}{a numeric named vector with scaling for ode
parameters of the system.  The names must correstond to the
parameter identifiers in the ODE specification. Each of the
ODE variables will be divided by the scaling factor.  For
example \code{scale=(center=2)} will divide the center ODE
variable by 2.}

\item{covs}{a matrix or dataframe the same number of rows as the
sampling points defined in the events \code{eventTable}.  This
is for time-varying covariates.}

\item{stiff}{a logical (\code{TRUE} by default) indicating whether
    the ODE system is stiff or not.

    For stiff ODE sytems (\code{stiff = TRUE}), \code{RxODE} uses the
    LSODA (Livermore Solver for Ordinary Differential Equations)
    Fortran package, which implements an automatic method switching
    for stiff and non-stiff problems along the integration
    interval, authored by Hindmarsh and Petzold (2003).

    For non-stiff systems (\code{stiff = FALSE}), \code{RxODE} uses
    DOP853, an explicit Runge-Kutta method of order 8(5, 3) of
    Dormand and Prince as implemented in C by Hairer and Wanner
    (1993).}

\item{transit_abs}{boolean indicating if this is a transit
compartment absorption}

\item{atol}{a numeric absolute tolerance (1e-08 by default) used
by the ODE solver to determine if a good solution has been
achieved;}

\item{rtol}{a numeric relative tolerance (1e-06 by default) used
by the ODE solver to determine if a good solution has been
achieved.}

\item{maxsteps}{maximum number of (internally defined) steps allowed
during one call to the solver. (5000 by default)}

\item{hmin}{The minimum absolute step size allowed. The default
value is 0.}

\item{hmax}{The maximum absolute step size allowed.  The default
checks for the maximum difference in times in your sampling and
events, and uses this value.  The value 0 is equivalent to
infinite maximum absolute step size.}

\item{hini}{The step size to be attempted on the first step. The
default value is determined by the solver (when hini = 0)}

\item{maxordn}{The maximum order to be allowed for the nonstiff
(Adams) method.  The default is 12.  It can be between 1 and
12.}

\item{maxords}{The maximum order to be allowed for the stiff (BDF)
method.  The default value is 5.  This can be between 1 and 5.}

\item{...}{Other arguments including scaling factors for each
compartment.  This includes S# = numeric will scale a compartment
# by a dividing the compartment amount by the scale factor,
like NONMEM.}

\item{covs_interpolation}{specifies the interpolation method for
time-varying covariates. When solving ODEs it often samples
times outside the sampling time specified in \code{events}.
When this happens, the time varying covariates are
interpolated.  Currently this can be \code{"linear"}
interpolation (the default), which interpolates the covariate
by solving the line between the observed covariates and
extrapolating the new covariate value. The other possibility is
\code{"constant"}, or Last observation carried forward.  In this
approach, the last observation of the covariate is considered
the current value of the covariate.}

\item{theta}{A vector of parameters that will be named THETA[#] and
added to inits}

\item{eta}{A vector of parameters that will be named ETA[#] and
added to inits}

\item{add.cov}{A boolean indicating if covariates should be added
to the output matrix or data frame. By default this is
disabled.}

\item{matrix}{A boolean inticating if a matrix should be returned
instead of the RxODE's solved object}
}
\value{
An \dQuote{rxSolve} solve object that stores the solved
    value in a matrix with as many rows as there are sampled time
    points and as many columns as system variables (as defined by
    the ODEs and additional assignments in the RxODE model code).
    It also stores information about the call to allow dynmaic
    updating of the solved object.

    The operations for the object are simialar to a data-frame, but
    expand the \code{$} and \code{[[""]]} access operators and
    assignment operators to resolve based on different parameter
    values, initial conditions, solver parameters, or events (by
    updaing the \code{time} variable).

    You can call the \code{\link{eventTable}} methods on the solved
    object to update the event table and resolve the system of
    equations.  % Should be able to use roxygen templates...
}
\description{
This uses RxODE family of objects, file, or model specification to
solve a ODE system.
}
\references{
Hindmarsh, A. C.
\emph{ODEPACK, A Systematized Collection of ODE Solvers}.
Scientific Computing, R. S. Stepleman et al. (Eds.),
North-Holland, Amsterdam, 1983, pp. 55-64.

Petzold, L. R.
\emph{Automatic Selection of Methods for Solving Stiff and Nonstiff
Systems of Ordinary Differential Equations}.
Siam J. Sci. Stat. Comput. 4 (1983), pp. 136-148.

Hairer, E., Norsett, S. P., and Wanner, G.
\emph{Solving ordinary differential equations I, nonstiff problems}.
2nd edition, Springer Series in Computational Mathematics,
Springer-Verlag (1993).
}
\seealso{
\code{\link{RxODE}}
}
\author{
Melissa Hallow, Wenping Wang and Matthew Fidler
}
