## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)

## ----message=FALSE------------------------------------------------------------
library(Ryacas0)

## -----------------------------------------------------------------------------
exp1 <- yacas(expression(Factor(x^2-1)))

## -----------------------------------------------------------------------------
Eval(exp1, list(x=4))

## -----------------------------------------------------------------------------
yacas("D(x)Sin(x)")

## -----------------------------------------------------------------------------
x <- Sym("x")

## -----------------------------------------------------------------------------
x+4

## -----------------------------------------------------------------------------
Integrate(sin(x), x)

## -----------------------------------------------------------------------------
x <- Sym("xs")
x
x+4
Eval(x+4, list(xs=5))

## -----------------------------------------------------------------------------
xs <- Sym('xs')

## -----------------------------------------------------------------------------
yacas(expression((10 + 2) * 5 + 7^7))
yacas(expression(1/14+5/21* (30- 1+ 1/2)))

## -----------------------------------------------------------------------------
#(Sym(10) + Sym(2)) * Sym(5) + Sym(7) ^ Sym(7)
Sym("10 * 2") * 5 + Sym(7) ^ 7
#(Sym(10) + 2) * 5 + Sym(7) ^ 7
#Sym("(10+2)*5 + 7^7")
Sym("1/14 + 5/21 * (30 - 1+1/2)")

## -----------------------------------------------------------------------------
yacas(expression(N(-12/2)))

## -----------------------------------------------------------------------------
Sym("-12/2")
#Eval(Sym("-12/2"))

## -----------------------------------------------------------------------------
yacas(expression(Factor(x^2-1)))
exp1 <- expression(x^2 + 2 * x^2)
exp2 <- expression(2 * exp0)
exp3 <- expression(6 * pi * x)
exp4 <- expression((exp1 * (1 - sin(exp3))) / exp2)
yacas(exp4)

## -----------------------------------------------------------------------------
Factor(xs^2-1)
exp1 <- xs^2 + 2 * xs^2
exp0 <- Sym("exp0")
exp2 <- 2 * Sym(exp0)
exp3 <- 6 * Pi * xs
exp4 <- exp1 * (1 - sin(exp3)) / exp2
exp4

## -----------------------------------------------------------------------------
yacas(expression(N(Sin(1)^2 + Cos(x)^2)))

## -----------------------------------------------------------------------------
N(sin(1)^2 + cos(xs)^2)

## -----------------------------------------------------------------------------
yacas("D(x)Sin(x)")

## -----------------------------------------------------------------------------
deriv(sin(xs), xs)

## -----------------------------------------------------------------------------
yacas("Clear(a,b,A,B)")

## -----------------------------------------------------------------------------
yacas("Integrate(x,a,b)Sin(x)")

## -----------------------------------------------------------------------------
as <- Sym("as")
bs <- Sym("bs")
Integrate(sin(xs), xs, as, bs)

## -----------------------------------------------------------------------------
yacas("Expand((1+x)^3)")

## -----------------------------------------------------------------------------
Expand((1+xs)^3)

## -----------------------------------------------------------------------------
yacas("texp := Taylor(x,0,3) Exp(x)")

## -----------------------------------------------------------------------------
texp <- Taylor(exp(xs), xs, 0, 3)
# Or: texp <- Sym("texp")

## -----------------------------------------------------------------------------
yacas("PrettyForm(texp)") 
yacas("TeXForm(texp)")

## -----------------------------------------------------------------------------
PrettyForm(texp) 
TeXForm(texp)

## -----------------------------------------------------------------------------
yacas("n := (10 + 2) * 5")
yacas("n := n+n")
#yacas("Set(z, Cos(a))")
#yacas("z+z")

## -----------------------------------------------------------------------------
Set(ns, (10 + 2) * 5)

## -----------------------------------------------------------------------------
ns <- Sym("ns")

## -----------------------------------------------------------------------------
Set(ns,123)
ns
ns^2

## -----------------------------------------------------------------------------
as <- Sym("as")
zs <- Sym("zs")
Set(zs, cos(as))
zs + zs

## -----------------------------------------------------------------------------
yacas(expression(n))
yacas("Clear(n)")
yacas(expression(n))

## -----------------------------------------------------------------------------
Set(ns, 1)
ns <- Sym("ns")
ns
Clear(ns)
ns

## -----------------------------------------------------------------------------
yacas("Exp(0)")
yacas("Exp(1)")
yacas("Sin(Pi/4)")
yacas("355/113")

## -----------------------------------------------------------------------------
exp(Sym(0))
exp(Sym(1))
sin(Pi/4)
Sym("355/113")

## -----------------------------------------------------------------------------
yacas("N(Exp(1))")
yacas("N(Sin(Pi/4))")
yacas("N(355/113)")

## -----------------------------------------------------------------------------
N(exp(1))
N(sin(Pi/4))
N(355/113)

## -----------------------------------------------------------------------------
yacas("N(355/133,20)")

## -----------------------------------------------------------------------------
N("355/113",20) 

## -----------------------------------------------------------------------------
yacas("Precision(5)")
yacas("N(355/113)")

## -----------------------------------------------------------------------------
Precision(5)
N("355/113")

## -----------------------------------------------------------------------------
yacas(expression(55/10))

## -----------------------------------------------------------------------------
Sym("55 / 10")

## -----------------------------------------------------------------------------
yacas("1/14+5/21*(30-(1+1/2)*5^2)")
yacas("0+x")
yacas("x+1*y")
yacas("Sin(ArcSin(alpha))+Tan(ArcTan(beta))")

## -----------------------------------------------------------------------------
Sym("1/14+5/21*(1*30-(1+1/2)*5^2)")
xs <- Sym("xs")
ys <- Sym("ys")
0+xs
xs+1*ys
sin(asin(xs))+tan(atan(ys))

## -----------------------------------------------------------------------------
yacas("I^2")
yacas("7+3*I")
yacas("Conjugate(%)")
yacas("Exp(3*I)")

## -----------------------------------------------------------------------------
I^2
7+3*I
Conjugate(7+3*I)
exp(3*I)

## -----------------------------------------------------------------------------
yacas("(1+x)^3")
yacas("%")
yacas("z:= %")

## -----------------------------------------------------------------------------
(1+x)^3
zs <- Sym("%")
zs

## -----------------------------------------------------------------------------
yacas("A:={{a,b},{c,d}}")
yacas("B:= (1+x)^2+k^3")
yacas("A")
yacas("B")

## -----------------------------------------------------------------------------
as <- Sym("as"); bs <- Sym("bs"); cs <- Sym("cs"); ds <- Sym("ds")
A <- List(List(as,bs), List(cs,ds))
ks <- Sym("ks")
B <- (1+xs)^2+ks^3
A
B

## -----------------------------------------------------------------------------
yacas("PrettyForm(A)")
yacas("PrettyForm(B)")

## -----------------------------------------------------------------------------
PrettyForm(A)
PrettyForm(B)

## -----------------------------------------------------------------------------
yacas("TeXForm(B)")

## -----------------------------------------------------------------------------
TeXForm(B)

## -----------------------------------------------------------------------------
yacas("40!")

## -----------------------------------------------------------------------------
Factorial(40)

## -----------------------------------------------------------------------------
yacas("Taylor(x,0,3) Exp(x)")
yacas("Taylor(x,a,3) Exp(x)")

## -----------------------------------------------------------------------------
xs <- Sym("xs")
Taylor(exp(xs),xs,0,3)
as <- Sym("as")
Taylor(exp(x),x,as,3)

## -----------------------------------------------------------------------------
yacas("InverseTaylor(x,0,2)Exp(x)")
yacas("Taylor(y,1,2)Ln(y)")

## -----------------------------------------------------------------------------
InverseTaylor(exp(xs),xs,0,2)
Taylor(log(ys),ys,1,2)

## -----------------------------------------------------------------------------
yacas("Solve(x/(1+x) == a, x)")
yacas("Solve(x^2+x == 0, x)")

## -----------------------------------------------------------------------------
Solve(xs/(1+xs) == as, xs)
Solve(xs^2+xs == 0, xs)

## -----------------------------------------------------------------------------
Solve(List(xs^2+ys^2==6, xs-ys==3), List(xs,ys))

## -----------------------------------------------------------------------------
# FIXME
#Solve(List(mean==(xs/(xs+ys)), variance==((xs*ys)/(((xs+ys)^2) * (xs+ys+1)))),
#    List(xs,ys))

## -----------------------------------------------------------------------------
yacas("Newton(Sin(x)-Exp(x),x, 0.5, 0.0001)")

## -----------------------------------------------------------------------------
Newton(sin(xs)-exp(xs),xs, 0.5, 0.0001) 

## -----------------------------------------------------------------------------
yacas(expression(Expand((1+x)^3)))

## -----------------------------------------------------------------------------
Expand((x+1)^3)

## -----------------------------------------------------------------------------
y <- Sym("y")
yacas("(x+y)^3-(x-y)^3")
yacas("Simplify(%)")


## -----------------------------------------------------------------------------
(x+y)^3-(x-y)^3
Simplify("%")

## -----------------------------------------------------------------------------
yacas("D(x) Sin(x)")

## -----------------------------------------------------------------------------
deriv(sin(xs), xs)

## -----------------------------------------------------------------------------
yacas("D(x,4)Sin(x)")

## -----------------------------------------------------------------------------
deriv(sin(xs),xs,4)

## -----------------------------------------------------------------------------
#yacas("Integrate(x,a,b)Sin(x)")
#yacas("Integrate(x,a,b)Ln(x)+x")
#yacas("Integrate(x)1/(x^2-1)")
yacas("Integrate(x)Sin(a*x)^2*Cos(b*x)")

## -----------------------------------------------------------------------------
#Integrate(sin(x),x,a,b)
#Integrate(log(x),x,a,b)
#Integrate(1/(x^2-1),x)
a <- Sym("a")
b <- Sym("b")
Integrate(sin(a*x)^2*cos(b*x),x)

## -----------------------------------------------------------------------------
#yacas("Limit(x,0)Sin(x)/x")
yacas("Limit(n,Infinity)(1+(1/n))^n")
yacas("Limit(h,0) (Sin(x+h)-Sin(x))/h")

## -----------------------------------------------------------------------------
#Limit(sin(x)/x,x,0)
ns <- Sym("ns")
Limit((1+(1/ns))^ns,ns,Infinity)
hs <- Sym("hs")
Limit((sin(xs+hs)-sin(xs))/hs,hs,0)

## -----------------------------------------------------------------------------
yacas("Subst(x,Cos(a))x+x")

## -----------------------------------------------------------------------------
Subst(xs+xs,xs,cos(as))

## -----------------------------------------------------------------------------
yacas("OdeSolve(y''==4*y)")
yacas("OdeSolve(y'==8*y)")

## -----------------------------------------------------------------------------
yacas("E4:={ {u1,u1,0},{u1,0,u2},{0,u2,0} }")
yacas("PrettyForm(E4)")

## -----------------------------------------------------------------------------
u1 <- Sym("u1")
u2 <- Sym("u2")
E4 <- List(List(u1, u1, 0), List(u1, 0, u2), List(0, u2, 0))
PrettyForm(E4)

## -----------------------------------------------------------------------------
yacas("E4i := Inverse(E4)")
yacas("Simplify(E4i)")
yacas("PrettyForm(Simplify(E4i))")

## -----------------------------------------------------------------------------
E4i <- Inverse(E4)
Simplify(E4i)
PrettyForm(Simplify(E4i))

## -----------------------------------------------------------------------------
yacas("Determinant(E4)")
yacas("Determinant(E4i)")
yacas("Simplify(E4i)")
yacas("Simplify(Determinant(E4i))")

## -----------------------------------------------------------------------------
determinant(E4)
determinant(E4i)
Simplify(E4i)
Simplify(determinant(E4i))

## -----------------------------------------------------------------------------
yacas(expression(Factor(x^2-1)),retclass='unquote')
yacas(expression(Factor(x^2-1)),retclass='character')

## -----------------------------------------------------------------------------
get_output_width()
set_output_width(120)
get_output_width()

