% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sym2.R
\name{Sym}
\alias{Sym}
\alias{Expr}
\alias{Exprq}
\alias{Ops.Expr}
\alias{Math.Expr}
\alias{deriv.Expr}
\alias{print.Expr}
\alias{as.character.Expr}
\alias{as.Sym}
\alias{as.Sym.Expr}
\alias{as.Sym.yacas}
\alias{as.character.Sym}
\alias{as.expression.Sym}
\alias{deriv.Sym}
\alias{Integrate}
\alias{OpenMath2R}
\alias{Ops.Sym}
\alias{Math.Sym}
\alias{Ops.yacas.symbol}
\alias{print.Sym}
\alias{determinant.Sym}
\alias{print.yacas}
\alias{SymExpr}
\alias{trans}
\alias{transtab}
\alias{yacas.symbol.value}
\alias{yDeriv}
\alias{yFactorial}
\alias{yIntegrate}
\alias{yLimit}
\alias{yrewrite}
\alias{yUnlist}
\alias{Simplify}
\alias{Factorial}
\alias{List}
\alias{Ver}
\alias{N}
\alias{Pi}
\alias{Clear}
\alias{Factor}
\alias{Expand}
\alias{Taylor}
\alias{InverseTaylor}
\alias{PrettyForm}
\alias{TeXForm}
\alias{Precision}
\alias{Conjugate}
\alias{PrettyPrinter}
\alias{Solve}
\alias{Newton}
\alias{Set}
\alias{Infinity}
\alias{I}
\alias{Limit}
\alias{Inverse}
\alias{Transpose}
\alias{as.Expr.formula}
\alias{Clear.Expr}
\alias{Clear.default}
\alias{Conjugate.Expr}
\alias{Conjugate.default}
\alias{determinant.Expr}
\alias{Expand.Expr}
\alias{Expand.default}
\alias{Factor.Expr}
\alias{Factor.default}
\alias{Factorial.Expr}
\alias{Factorial.default}
\alias{Integrate.Expr}
\alias{Integrate.default}
\alias{Inverse.Expr}
\alias{Inverse.default}
\alias{InverseTaylor.default}
\alias{Limit.Expr}
\alias{Limit.default}
\alias{List.Expr}
\alias{List.default}
\alias{N.Expr}
\alias{N.default}
\alias{Newton.Expr}
\alias{Newton.default}
\alias{Precision.Expr}
\alias{Precision.default}
\alias{PrettyForm.Expr}
\alias{PrettyForm.default}
\alias{PrettyPrinter.Expr}
\alias{PrettyPrinter.default}
\alias{Simplify.Expr}
\alias{Simplify.default}
\alias{Solve.Expr}
\alias{Solve.default}
\alias{Taylor.Expr}
\alias{Taylor.default}
\alias{TeXForm.Expr}
\alias{TeXForm.default}
\alias{Ver.Expr}
\alias{Ver.default}
\alias{Identity.default}
\alias{Identity}
\alias{Subst}
\alias{Subst.default}
\alias{\%Where\%}
\alias{\%Where\%.default}
\alias{CharacteristicEquation}
\alias{FindRoots}
\alias{EigenValues}
\title{Sym}
\usage{
Sym(...) 
Expr(x)
}
\arguments{
\item{\dots}{An R character string or object that can be coerced to a
character string.}

\item{x}{An R expression.}
}
\value{
\code{Sym} returns a \code{"Sym"} object and \code{Expr} returns an
\code{"Expr"} object.
}
\description{
The Symbol interface to yacas.
}
\details{
An object of class \code{"Sym"} is internally a yacas character string. An
object of class \code{"Expr"} is internally an R expression. One can combine
such objects using the Math and Ops R operators (see help(Math) and
help(Ops) for a list).  Also there are methods for a number of R generics:
\code{as.character.Sym}, \code{as.expression.Sym}, \code{determinant.Sym},
\code{deriv.Sym} and \code{print.Sym} and yacas-oriented functions: Clear,
Conjugate, Expand, Factor, Factorial, I, Identity, Infinity, Integrate,
Inverse, InverseTaylor, Limit, List, N, Newton, Pi, Precision, PrettyForm,
PrettyPrinter, Set, Simplify, Solve, Subst, Taylor, TeXForm, Transpose,
Ver and "\%Where\%" all of which have the same meaning as the corresponding yacas
commands. Try \code{vignette("Rycas-Sym")} for many examples.

Get \code{Sym} objects with \code{getSyms()}.
}
\note{
Currently the only \code{Expr} methods implemented are
as.character.Expr, deriv.Expr, Math.Expr, Ops.Expr and print.Expr.
}
\examples{

x <- Sym("x")
x*x
Integrate(x*x, x)
Sym("\%") \%Where\% list(x = 10)

acos(Sym("1/2"))

y <- Exprq(x)
y*y
deriv(y*y, y)
Exprq(acos(1/2))

}
\seealso{
\code{\link[=as.Sym.matrix]{as.Sym.matrix()}}
}
\keyword{symbolmath}
