% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SACCRCalculator.R
\name{SACCRCalculator}
\alias{SACCRCalculator}
\title{SA-CCR Calculator}
\usage{
SACCRCalculator(
  trades_filename,
  csa_filename,
  coll_filename,
  JSON = FALSE,
  simplified = FALSE,
  OEM = FALSE,
  export_results = FALSE,
  ignore_margin = FALSE
)
}
\arguments{
\item{trades_filename}{a .csv file containing the trades}

\item{csa_filename}{a .csv file containing CSAs}

\item{coll_filename}{a .csv file containing collaterals}

\item{JSON}{(optional) if TRUE it returns a json string}

\item{simplified}{(optional) if TRUE, the simplified SA-CCR is being calculated}

\item{OEM}{(optional) if TRUE, the Original Exposure Method is being calculated}

\item{export_results}{(optional) if TRUE, a csv with the exposure at the top level will be exported}

\item{ignore_margin}{(optional) if TRUE, the margin agreement workflow will be turned off}
}
\value{
The relevant exposure trees
}
\description{
Returns a tree structure depicting the add-on calculations on different hedging/netting sets
}
\references{
Regulation (EU) 2019/876 of the European Parliament and of the Council of 20 May 2019
http://data.europa.eu/eli/reg/2019/876/oj
}
\author{
Tasos Grivas <tasos@openriskcalculator.com>
}
