% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assess_SCA_ext.R
\name{SCA_DDM}
\alias{SCA_DDM}
\title{SCA models with time-varying natural mortality}
\usage{
SCA_DDM(
  x = 1,
  Data,
  AddInd = "B",
  SR = c("BH", "Ricker", "none"),
  vulnerability = c("logistic", "dome"),
  catch_eq = c("Baranov", "Pope"),
  CAA_dist = c("multinomial", "lognormal"),
  CAA_multiplier = 50,
  rescale = "mean1",
  max_age = Data@MaxAge,
  start = NULL,
  prior = list(),
  fix_h = TRUE,
  fix_F_equilibrium = TRUE,
  fix_omega = TRUE,
  fix_tau = TRUE,
  LWT = list(),
  early_dev = c("comp_onegen", "comp", "all"),
  late_dev = "comp50",
  M_bounds = NULL,
  integrate = FALSE,
  silent = TRUE,
  opt_hess = FALSE,
  n_restart = ifelse(opt_hess, 0, 1),
  control = list(iter.max = 2e+05, eval.max = 4e+05),
  inner.control = list(),
  ...
)
}
\arguments{
\item{x}{A position in the Data object (by default, equal to one for assessments).}

\item{Data}{An object of class Data}

\item{AddInd}{A vector of integers or character strings indicating the indices to be used in the model. Integers assign the index to
the corresponding index in Data@AddInd, "B" (or 0) represents total biomass in Data@Ind, "VB" represents vulnerable biomass in
Data@VInd, and "SSB" represents spawning stock biomass in Data@SpInd. Vulnerability to the survey is fixed in the model.}

\item{SR}{Stock-recruit function (either \code{"BH"} for Beverton-Holt, \code{"Ricker"}, or \code{"none"} for constant mean recruitment).}

\item{vulnerability}{Whether estimated vulnerability is \code{"logistic"} or \code{"dome"} (double-normal).
See details for parameterization.}

\item{catch_eq}{Whether to use the Baranov equation or Pope's approximation to calculate the predicted catch at age in the model.}

\item{CAA_dist}{Whether a multinomial or lognormal distribution is used for likelihood of the catch-at-age matrix. See details.}

\item{CAA_multiplier}{Numeric for data weighting of catch-at-age matrix if \code{CAA_hist = "multinomial"}. Otherwise ignored. See details.}

\item{rescale}{A multiplicative factor that rescales the catch in the assessment model, which
can improve convergence. By default, \code{"mean1"} scales the catch so that time series mean is 1, otherwise a numeric.
Output is re-converted back to original units.}

\item{max_age}{Integer, the maximum age (plus-group) in the model.}

\item{start}{Optional list of starting values. Entries can be expressions that are evaluated in the function. See details.}

\item{prior}{A named list for the parameters of any priors to be added to the model. See below.}

\item{fix_h}{Logical, whether to fix steepness to value in \code{Data@steep} in the model for \code{SCA}. This only affects
calculation of reference points for \code{SCA2}.}

\item{fix_F_equilibrium}{Logical, whether the equilibrium fishing mortality prior to the first year of the model
is estimated. If \code{TRUE}, \code{F_equilibrium} is fixed to value provided in \code{start} (if provided),
otherwise, equal to zero (assumes unfished conditions).}

\item{fix_omega}{Logical, whether the standard deviation of the catch is fixed. If \code{TRUE},
omega is fixed to value provided in \code{start} (if provided), otherwise, value based on \code{Data@CV_Cat}.}

\item{fix_tau}{Logical, the standard deviation of the recruitment deviations is fixed. If \code{TRUE},
tau is fixed to value provided in \code{start} (if provided), otherwise, value based on \code{Data@sigmaR}.}

\item{LWT}{A named list (Index, CAA, Catch) of likelihood weights for the data components. For the index, a vector of length survey. For
CAL and Catch, a single value.}

\item{early_dev}{Numeric or character string describing the years for which recruitment deviations are estimated in \code{SCA}. By default,
equal to \code{"comp_onegen"}, where rec devs are estimated one full generation prior to the first year when catch-at-age (CAA) data are available.
With \code{"comp"}, rec devs are estimated starting in the first year with CAA. With \code{"all"}, rec devs start at the beginning of the model.
If numeric, the number of years after the first year of the model for which to start estimating rec devs. Use negative numbers for years prior to the first year.}

\item{late_dev}{Typically, a numeric for the number of most recent years in which recruitment deviations will
not be estimated in \code{SCA} (recruitment in these years will be based on the mean predicted by stock-recruit relationship).
By default, \code{"comp50"} uses the number of ages (smaller than the mode)
for which the catch-at-age matrix has less than half the abundance than that at the mode.}

\item{M_bounds}{A numeric vector of length 2 to indicate the M as B/B0 approaches zero and one, respectively.
By default, set to 75\% and 125\%, respectively, of \code{Data@Mort[x]}.}

\item{integrate}{Logical, whether the likelihood of the model integrates over the likelihood
of the recruitment deviations (thus, treating it as a random effects/state-space variable).
Otherwise, recruitment deviations are penalized parameters.}

\item{silent}{Logical, passed to \code{\link[TMB:MakeADFun]{TMB::MakeADFun()}}, whether TMB
will print trace information during optimization. Used for diagnostics for model convergence.}

\item{opt_hess}{Logical, whether the hessian function will be passed to \code{\link[stats:nlminb]{stats::nlminb()}} during optimization
(this generally reduces the number of iterations to convergence, but is memory and time intensive and does not guarantee an increase
in convergence rate). Ignored if \code{integrate = TRUE}.}

\item{n_restart}{The number of restarts (calls to \code{\link[stats:nlminb]{stats::nlminb()}}) in the optimization procedure, so long as the model
hasn't converged. The optimization continues from the parameters from the previous (re)start.}

\item{control}{A named list of arguments for optimization to be passed to
\code{\link[stats:nlminb]{stats::nlminb()}}.}

\item{inner.control}{A named list of arguments for optimization of the random effects, which
is passed on to \code{\link[TMB:newton]{TMB::newton()}}.}

\item{...}{Other arguments to be passed, including \code{yind} (an expression for the vector of years to include in the model, useful for debugging for data lags),
\code{M_at_age} (set to TRUE to specify a matrix of M by year and age from the operating model and the bias parameter),
\code{IAA_hist} (an array of index age proportions by year, age, survey), and \code{IAA_n} (a matrix of multinomial sample size by year and survey).}
}
\value{
An object of class \linkS4class{Assessment}.
}
\description{
A modification of \code{SCA} that incorporates density-dependent effects on M based on biomass depletion (Forrest et al. 2018).
Set the bounds of M in the \code{M_bounds} argument, a length-2 vector where the first entry is M0, the M as B/B0 >= 1,
and the second entry is M1, the M as B/B0 approaches zero. Note that M0 can be greater than M1 (compensatory)
or M0 can be less than M1 (depensatory).
}
\details{
See \link{SCA} for more information on all arguments.
}
\section{Online Documentation}{

Model description and equations are available on the openMSE
\href{https://openmse.com/features-assessment-models/2-sca/}{website}.
}

\examples{
res <- SCA_DDM(Data = MSEtool::SimulatedData)

}
\references{
Forrest, R.E., Holt, K.R., and Kronlund, A.R. 2018. Performance of alternative harvest control rules for two Pacific groundfish
stocks with uncertain natural mortality: Bias, robustness and trade-offs. Fisheries Research 2016: 259-286.
}
\seealso{
\link{SCA} \link{SCA_RWM} \link{plot.Assessment} \link{summary.Assessment} \link{retrospective} \link{profile} \link{make_MP}
}
\author{
Q. Huynh
}
