% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppp.PPPDiffRef.R
\name{PPPPreserveOrder}
\alias{PPPPreserveOrder}
\title{PPPPreserveOrder}
\description{
Set an order between cols, and preserve it by swapping values after
the correction
}
\details{
Set an order between cols, and preserve it by swapping values after
the correction
}
\examples{
## Build data
X = matrix( stats::rnorm( n = 20 ) , ncol = 2 )

## PPP
ppp   = SBCK::PPPPreserveOrder$new( cols = base::c(1,2) )
Xt    = ppp$transform(X) ## Nothing
Xti   = ppp$itransform(Xt) ## Order

}
\section{Super class}{
\code{\link[SBCK:PrePostProcessing]{SBCK::PrePostProcessing}} -> \code{PPPPreserveOrder}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PPPPreserveOrder-new}{\code{PPPPreserveOrder$new()}}
\item \href{#method-PPPPreserveOrder-transform}{\code{PPPPreserveOrder$transform()}}
\item \href{#method-PPPPreserveOrder-itransform}{\code{PPPPreserveOrder$itransform()}}
\item \href{#method-PPPPreserveOrder-clone}{\code{PPPPreserveOrder$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="SBCK" data-topic="PrePostProcessing" data-id="fit"><a href='../../SBCK/html/PrePostProcessing.html#method-PrePostProcessing-fit'><code>SBCK::PrePostProcessing$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="SBCK" data-topic="PrePostProcessing" data-id="predict"><a href='../../SBCK/html/PrePostProcessing.html#method-PrePostProcessing-predict'><code>SBCK::PrePostProcessing$predict()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PPPPreserveOrder-new"></a>}}
\if{latex}{\out{\hypertarget{method-PPPPreserveOrder-new}{}}}
\subsection{Method \code{new()}}{
Create a new PPPPreserveOrder object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PPPPreserveOrder$new(cols = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cols}}{The columns to keep the order}

\item{\code{...}}{Others arguments are passed to PrePostProcessing}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `PPPPreserveOrder` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PPPPreserveOrder-transform"></a>}}
\if{latex}{\out{\hypertarget{method-PPPPreserveOrder-transform}{}}}
\subsection{Method \code{transform()}}{
nothing occur here
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PPPPreserveOrder$transform(X)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{Data to transform}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Xt a transformed matrix
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PPPPreserveOrder-itransform"></a>}}
\if{latex}{\out{\hypertarget{method-PPPPreserveOrder-itransform}{}}}
\subsection{Method \code{itransform()}}{
sort along cols
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PPPPreserveOrder$itransform(Xt)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Xt}}{Data to transform}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
X a transformed matrix
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PPPPreserveOrder-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PPPPreserveOrder-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PPPPreserveOrder$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
